/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.util;

import com.urbancode.shell.Os;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.IOUtils;

public class UnzipUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File file, File dir) throws IOException {
        boolean doUnixPermissions = Os.isFamily((String)"unix");
        ZipFile zipFile = new ZipFile(file);
        try {
            Enumeration entries = zipFile.getEntriesInPhysicalOrder();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                File entryDestination = new File(dir, entry.getName());
                if (entry.isDirectory()) {
                    entryDestination.mkdirs();
                } else {
                    entryDestination.getParentFile().mkdirs();
                    InputStream entryStream = null;
                    FileOutputStream fileStream = new FileOutputStream(entryDestination);
                    try {
                        entryStream = zipFile.getInputStream(entry);
                        IOUtils.copy((InputStream)entryStream, (OutputStream)fileStream);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)entryStream);
                        IOUtils.closeQuietly((OutputStream)fileStream);
                    }
                }
                if (!doUnixPermissions || entry.getUnixMode() <= 0) continue;
                Set<PosixFilePermission> perms = UnzipUtil.unixModeToPermissions(entry.getUnixMode());
                Files.setPosixFilePermissions(Paths.get(entryDestination.getAbsolutePath(), new String[0]), perms);
            }
        }
        finally {
            ZipFile.closeQuietly((ZipFile)zipFile);
        }
    }

    static Set<PosixFilePermission> unixModeToPermissions(int mode) {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        if ((mode & 1) == 1) {
            perms.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        if ((mode & 2) == 2) {
            perms.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((mode & 4) == 4) {
            perms.add(PosixFilePermission.OTHERS_READ);
        }
        if ((mode & 8) == 8) {
            perms.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((mode & 0x10) == 16) {
            perms.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((mode & 0x20) == 32) {
            perms.add(PosixFilePermission.GROUP_READ);
        }
        if ((mode & 0x40) == 64) {
            perms.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((mode & 0x80) == 128) {
            perms.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((mode & 0x100) == 256) {
            perms.add(PosixFilePermission.OWNER_READ);
        }
        return perms;
    }
}

