/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreUtil {
    public static final Logger log = LoggerFactory.getLogger(KeyStoreUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore loadKeyStore(String keyStorePath, String keyStoreType, String keyStorePwd) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        File keystoreFile = new File(keyStorePath);
        if (keystoreFile.exists()) {
            FileInputStream input = new FileInputStream(keystoreFile);
            try {
                keyStore.load(input, keyStorePwd.toCharArray());
            }
            finally {
                IOUtils.closeQuietly((InputStream)input);
            }
        } else {
            keyStore.load(null, keyStorePwd.toCharArray());
        }
        return keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeKeyStore(KeyStore keyStore, String keyStorePath, String keyStorePwd) throws Exception {
        File keyStoreFile = new File(keyStorePath);
        keyStoreFile.getParentFile().mkdirs();
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(keyStoreFile);
            keyStore.store(fileOutputStream, keyStorePwd.toCharArray());
            log.trace("Saving key store to file [{}]", (Object)keyStorePath);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
    }
}

