/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.resources.json;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.urbancode.sync.persistence.cloud.ConnectorPluginCloudDao;
import com.ibm.cloud.urbancode.sync.persistence.cloud.ConnectorPluginRefTypeAdapter;
import com.ibm.cloud.urbancode.sync.plugin.connector.ConnectorPlugin;
import com.ibm.cloud.urbancode.sync.resources.json.Association;
import com.ibm.cloud.urbancode.sync.resources.json.JsonHidden;
import com.ibm.cloud.urbancode.sync.resources.json.JsonReadOnly;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Id;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Updater {
    public static final Logger log = LoggerFactory.getLogger(Updater.class);
    private List<Class<?>> treatAsIds = Collections.emptyList();
    private boolean allAssociations = true;
    private ConnectorPluginCloudDao pluginDao;

    public Updater(ConnectorPluginCloudDao pluginDao) {
        this.pluginDao = pluginDao;
    }

    public void update(Object entity, String json) {
        JsonObject parsedJson = new JsonParser().parse(json).getAsJsonObject();
        this.update(entity, parsedJson);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void update(Object entity, JsonObject parsedJson) {
        try {
            GsonBuilder builder = new GsonBuilder();
            Class<?> type = entity.getClass();
            Strategy strategy = new Strategy(type);
            builder.setExclusionStrategies(new ExclusionStrategy[]{strategy});
            if (this.allAssociations && !type.equals(ConnectorPlugin.class)) {
                builder.registerTypeAdapter(ConnectorPlugin.class, (Object)new ConnectorPluginRefTypeAdapter(this.pluginDao));
            }
            Gson gson = builder.create();
            Object prototype = gson.fromJson((JsonElement)parsedJson, type);
            for (Name name : strategy.getRootPropertyNames()) {
                if (!parsedJson.has(name.json)) continue;
                try {
                    Field field = this.getField(type, name.field);
                    field.setAccessible(true);
                    field.set(entity, field.get(prototype));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                    return;
                }
            }
        }
        catch (RuntimeException e) {
            log.error("Error updating object from json", (Throwable)e);
        }
    }

    Field getField(Class<?> type, String name) {
        Field result = null;
        while (type != null) {
            try {
                result = type.getDeclaredField(name);
                break;
            }
            catch (NoSuchFieldException swallow) {
                type = type.getSuperclass();
            }
        }
        return result;
    }

    class Strategy
    implements ExclusionStrategy {
        Set<Name> rootPropertyNames = new HashSet<Name>();
        Class<?> rootClass;

        public Strategy(Class<?> rootClass) {
            this.rootClass = rootClass;
        }

        public Set<Name> getRootPropertyNames() {
            return this.rootPropertyNames;
        }

        public boolean shouldSkipClass(Class<?> cls) {
            return false;
        }

        public boolean shouldSkipField(FieldAttributes field) {
            if (field.getAnnotation(Id.class) != null) {
                return true;
            }
            if (field.getAnnotation(JsonHidden.class) != null) {
                return true;
            }
            if (field.getAnnotation(JsonReadOnly.class) != null) {
                return true;
            }
            if (field.hasModifier(8)) {
                return true;
            }
            if (field.hasModifier(128)) {
                return true;
            }
            if (field.hasModifier(16)) {
                return true;
            }
            if (Association.isAssociation(field) && !Updater.this.treatAsIds.contains(field.getDeclaredType()) && !Updater.this.allAssociations) {
                return true;
            }
            if (Association.isToMany(field)) {
                return true;
            }
            if (field.getDeclaringClass().isAssignableFrom(this.rootClass)) {
                this.rootPropertyNames.add(new Name(field));
            }
            return false;
        }
    }

    static class Name {
        final String field;
        final String json;

        Name(FieldAttributes fieldAttr) {
            String name = this.field = fieldAttr.getName();
            SerializedName ann = (SerializedName)fieldAttr.getAnnotation(SerializedName.class);
            if (ann != null) {
                name = ann.value();
            }
            this.json = name;
        }

        public String toString() {
            return this.json;
        }

        public boolean equals(Object other) {
            return this.field.equals(((Name)other).field);
        }
    }
}

