/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.resources.json;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ibm.cloud.urbancode.sync.resources.json.Association;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class JsonSerializer {
    Map<Class<?>, Set<String>> assocNames = new HashMap();
    Gson gson;

    public JsonSerializer(Map<Class<?>, Object> typeAdapterMap, Association ... associations) {
        if (associations != null) {
            for (Association a : associations) {
                Set<String> names = this.assocNames.get(a.getEntityClass());
                if (names == null) {
                    names = new HashSet<String>();
                    this.assocNames.put(a.getEntityClass(), names);
                }
                names.addAll(a.getPropertyNames());
            }
        }
        GsonBuilder builder = new GsonBuilder();
        if (typeAdapterMap != null) {
            for (Map.Entry<Class<?>, Object> entry : typeAdapterMap.entrySet()) {
                builder.registerTypeAdapter((Type)entry.getKey(), entry.getValue());
            }
        }
        builder.addSerializationExclusionStrategy((ExclusionStrategy)new AssocExclusionStrategy());
        this.gson = builder.create();
    }

    public String toJson(Object src) {
        return this.gson.toJson(src);
    }

    class AssocExclusionStrategy
    implements ExclusionStrategy {
        AssocExclusionStrategy() {
        }

        public boolean shouldSkipClass(Class<?> cls) {
            return false;
        }

        public boolean shouldSkipField(FieldAttributes field) {
            if (field.hasModifier(8)) {
                return true;
            }
            if (field.hasModifier(128)) {
                return true;
            }
            if (field.hasModifier(16)) {
                return true;
            }
            if (Association.isAssociation(field)) {
                Class key = field.getDeclaringClass();
                Set<String> names = JsonSerializer.this.assocNames.get(key);
                boolean skip = names == null || !names.contains(field.getName());
                return skip;
            }
            return false;
        }
    }
}

