/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.resources.json;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.FieldAttributes;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;

public class Association {
    static final Class<?>[] associationAnnotations = new Class[]{OneToOne.class, OneToMany.class, ManyToOne.class, ManyToMany.class, Embedded.class, ElementCollection.class};
    static final Class<?>[] toManyAnnotations = new Class[]{OneToMany.class, ManyToMany.class, ElementCollection.class};
    final Class<?> entityClass;
    final Set<String> propertyNames;

    static boolean isAssociation(FieldAttributes field) {
        for (Class<?> c : associationAnnotations) {
            if (field.getAnnotation(c) == null) continue;
            return true;
        }
        return false;
    }

    static boolean isToMany(FieldAttributes field) {
        for (Class<?> c : toManyAnnotations) {
            if (field.getAnnotation(c) == null) continue;
            return true;
        }
        return false;
    }

    public static Multimap<Class<?>, String> combine(Iterable<Association> associations) {
        LinkedHashMultimap assocNames = LinkedHashMultimap.create();
        for (Association a : associations) {
            assocNames.putAll(a.getEntityClass(), a.getPropertyNames());
        }
        return assocNames;
    }

    public Association(Class<?> entityClass, String ... propertyNames) {
        this.entityClass = entityClass;
        this.propertyNames = new HashSet<String>(Arrays.asList(propertyNames));
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.propertyNames);
    }

    public String toString() {
        return this.entityClass.getSimpleName() + this.propertyNames;
    }
}

