/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.resources.json;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.ibm.cloud.urbancode.sync.resources.json.Association;
import java.util.Arrays;
import java.util.Collection;

public class AssocExclusionStrategy
implements ExclusionStrategy {
    Multimap<Class<?>, String> assocNames = HashMultimap.create();
    boolean allAssociations = false;

    public AssocExclusionStrategy() {
    }

    public AssocExclusionStrategy(boolean allAssociations) {
        this.allAssociations = allAssociations;
    }

    public AssocExclusionStrategy(Association ... associations) {
        this(Arrays.asList(associations));
    }

    public AssocExclusionStrategy(Collection<Association> associations) {
        this.assocNames = Association.combine(associations);
    }

    public boolean shouldSkipClass(Class<?> cls) {
        return false;
    }

    public boolean shouldSkipField(FieldAttributes field) {
        if (field.hasModifier(8)) {
            return true;
        }
        if (field.hasModifier(128)) {
            return true;
        }
        if (field.hasModifier(16)) {
            return true;
        }
        if (Association.isAssociation(field)) {
            if (this.allAssociations) {
                return false;
            }
            Class key = field.getDeclaringClass();
            return !this.assocNames.containsEntry((Object)key, (Object)field.getName());
        }
        return false;
    }
}

