/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.resources;

import com.ibm.cloud.urbancode.sync.cloud.CloudSocketComponent;
import java.io.IOException;
import java.net.URI;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
@Order(value=0)
public class SecurityFilter
implements Filter {
    private final boolean isDev;
    private final CloudSocketComponent socketService;

    @Inject
    public SecurityFilter(Environment environment, CloudSocketComponent socketService) {
        boolean foundDev = false;
        for (String activeProfile : environment.getActiveProfiles()) {
            if (!"dev".equals(activeProfile)) continue;
            foundDev = true;
            break;
        }
        this.isDev = foundDev;
        this.socketService = socketService;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            throw new ServletException("Expecting HTTP requests");
        }
        this.doHttpFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    void doHttpFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String pathInfo = request.getRequestURI();
        if (pathInfo.equals("/api/status") || pathInfo.equals("/favicon.ico") || pathInfo.equals("/login") || pathInfo.equals("/register") || pathInfo.startsWith("/css/") || pathInfo.startsWith("/images/") || pathInfo.startsWith("/js/") || pathInfo.startsWith("/lib/")) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else if (pathInfo.startsWith("/api/registration")) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else if (!this.socketService.isRegistered()) {
            URI uri = UriBuilder.fromPath((String)"/register").build(new Object[0]);
            response.sendRedirect(uri.toString());
        } else if (pathInfo.startsWith("/api/login")) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            String authHeader = request.getHeader("Authorization");
            HttpSession session = request.getSession();
            if (this.socketService.isRegistered() && StringUtils.isNotBlank((CharSequence)authHeader) && authHeader.startsWith("CloudSyncToken ")) {
                String expectedHeader = "CloudSyncToken " + this.socketService.getSyncToken();
                if (expectedHeader.equals(authHeader)) {
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                } else {
                    response.sendError(401);
                }
            } else if (this.isDev || session.getAttribute("user") != null) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else if (pathInfo.startsWith("/api/")) {
                response.addHeader("location", "/login");
                response.sendError(401);
            } else {
                URI uri = UriBuilder.fromPath((String)"/login").build(new Object[0]);
                response.sendRedirect(uri.toString());
            }
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

