/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.resources;

import com.ibm.cloud.urbancode.sync.cloud.CloudSocketComponent;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.apache.wink.json4j.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@Path(value="/registration")
public class RegistrationResource {
    @Autowired
    private CloudSocketComponent socketService;
    @Value(value="${registrationUrl}")
    private String registrationUrl;

    @GET
    public Response registration() throws URISyntaxException {
        if (this.socketService.isRegistered()) {
            return this.responseToRedirectToIntegrations();
        }
        URI uri = UriBuilder.fromPath((String)"/register").build(new Object[0]);
        return Response.seeOther((URI)uri).build();
    }

    @GET
    @Path(value="/register")
    public Response register(@Context UriInfo uriInfo) throws URISyntaxException {
        if (this.socketService.isRegistered()) {
            return this.responseToRedirectToIntegrations();
        }
        String syncId = this.socketService.getSyncId();
        URI callbackUrl = uriInfo.getBaseUriBuilder().path("registration").path("callback").queryParam("syncId", new Object[]{syncId}).build(new Object[0]);
        URI uri = UriBuilder.fromUri((String)this.registrationUrl).path("sync").path("register").queryParam("syncId", new Object[]{syncId}).queryParam("redirectUrl", new Object[]{callbackUrl}).build(new Object[0]);
        return Response.seeOther((URI)uri).build();
    }

    @GET
    @Path(value="/callback")
    public Response callback(@Context HttpServletRequest request) throws Exception {
        if (this.socketService.isRegistered()) {
            return this.responseToRedirectToIntegrations();
        }
        String error = request.getParameter("error");
        String syncId = request.getParameter("syncId");
        String syncToken = request.getParameter("syncToken");
        String registrar = request.getParameter("registrar");
        if (!this.socketService.getSyncId().equals(syncId)) {
            throw new Exception("Invalid id returned from registration");
        }
        if (StringUtils.isNotBlank((CharSequence)syncToken)) {
            JSONObject registrarJson = new JSONObject(registrar);
            String registrarName = registrarJson.optString("sub");
            this.socketService.setRegistration(syncToken, registrarName);
            request.getSession().setAttribute("user", (Object)registrarName);
            request.getSession().setAttribute("userInfo", (Object)registrar);
            return this.responseToRedirectToIntegrations();
        }
        throw new Exception("Error during registration: " + error);
    }

    private Response responseToRedirectToIntegrations() {
        URI uri = UriBuilder.fromPath((String)"/").build(new Object[0]);
        return Response.seeOther((URI)uri).build();
    }
}

