/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.resources;

import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import com.ibm.cloud.urbancode.sync.persistence.cloud.ConnectorPluginCloudDao;
import com.ibm.cloud.urbancode.sync.persistence.cloud.IntegrationCloudDao;
import com.ibm.cloud.urbancode.sync.plugin.Plugin;
import com.ibm.cloud.urbancode.sync.plugin.PluginInitialization;
import com.ibm.cloud.urbancode.sync.plugin.UIFieldDefinition;
import com.ibm.cloud.urbancode.sync.plugin.loader.PluginLoader;
import com.ibm.cloud.urbancode.sync.resources.CSResource;
import com.ibm.cloud.urbancode.sync.resources.json.Association;
import com.ibm.cloud.urbancode.sync.resources.json.JsonSerializer;
import com.sun.jersey.multipart.FormDataParam;
import com.urbancode.air.i18n.TranslateUtil;
import com.urbancode.air.property.prop_def.PropDef;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.UUID;
import java.util.zip.ZipException;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="/plugins")
@Produces(value={"application/json"})
@Component(value="PluginsResource")
public class PluginsResource
extends CSResource<Plugin> {
    public static final Logger log = LoggerFactory.getLogger(PluginsResource.class);
    @Inject
    private ConnectorPluginCloudDao dao;
    @Inject
    private IntegrationCloudDao integrationDao;
    @Inject
    private PluginInitialization pluginInitialization;

    @GET
    @Path(value="{id}")
    public String getPlugin(@PathParam(value="id") UUID id) {
        Plugin plugin = (Plugin)this.dao.get(id);
        JsonSerializer serial = new JsonSerializer(null, new Association[0]);
        return serial.toJson(plugin);
    }

    @GET
    @Produces(value={"application/json"})
    public String getAll() throws Exception {
        List plugins = this.dao.getAll();
        JsonArray result = new JsonArray();
        JsonSerializer serial = new JsonSerializer(null, new Association(UIFieldDefinition.class, "propDef"), new Association(PropDef.class, "allowedValues"));
        JsonParser parser = new JsonParser();
        if (plugins != null) {
            for (Plugin plugin : plugins) {
                result.add(parser.parse(serial.toJson(plugin)));
            }
        }
        return result.toString();
    }

    @POST
    @Path(value="import")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/html"})
    public String importPlugin(@FormDataParam(value="file") InputStream uploadedInputStream) throws Exception {
        JSONObject jsonResult = new JSONObject();
        try {
            File stagePluginFile = File.createTempFile("plugin-", ".zip");
            FileOutputStream out = new FileOutputStream(stagePluginFile);
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = uploadedInputStream.read(bytes)) != -1) {
                ((OutputStream)out).write(bytes, 0, read);
            }
            uploadedInputStream.close();
            out.flush();
            ((OutputStream)out).close();
            this.loadPlugin(stagePluginFile);
            jsonResult.put("status", (Object)"ok");
        }
        catch (ZipException zipEx) {
            jsonResult.put("status", (Object)"failed");
            jsonResult.put("error", (Object)TranslateUtil.i18n((String)"An exception occured while opening plugin zip file ( %s )", (Object[])new Object[]{zipEx.getMessage()}));
            log.error("Error loading plugin", (Throwable)zipEx);
        }
        catch (Exception e) {
            jsonResult.put("status", (Object)"failed");
            if (e.getMessage() == null) {
                jsonResult.put("error", (Object)TranslateUtil.i18n((String)"An exception ( %s ) occured while loading the plugin ", (Object[])new Object[]{e.toString()}));
            } else {
                jsonResult.put("error", (Object)TranslateUtil.i18n((String)e.getMessage(), (Object[])new Object[0]));
            }
            log.error("Error loading plugin", (Throwable)e);
        }
        return "<html><body><textarea>" + jsonResult.toString() + "</textarea></body></html>";
    }

    private void loadPlugin(File pluginFile) throws Exception {
        PluginLoader loader = new PluginLoader(this.dao, this.integrationDao, this.pluginInitialization.getPluginRepoDir(), pluginFile);
        loader.loadPlugin();
    }
}

