/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.resources;

import java.net.URI;
import javax.inject.Inject;
import javax.ws.rs.core.UriBuilder;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.wink.json4j.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class LoginVerification {
    private final OkHttpClient client;
    private final String registrationUrl;

    @Inject
    public LoginVerification(@Value(value="${registrationUrl}") String registrationUrl) {
        this.registrationUrl = registrationUrl;
        this.client = new OkHttpClient.Builder().build();
    }

    public JSONObject verify(String accessToken) throws Exception {
        URI uri = UriBuilder.fromUri((String)this.registrationUrl).path("auth").path("verify").queryParam("accessToken", new Object[]{accessToken}).build(new Object[0]);
        Request request = new Request.Builder().url(uri.toString()).build();
        Response response = this.client.newCall(request).execute();
        try {
            if (response.code() == 200) {
                String body = response.body().string();
                JSONObject json = new JSONObject(body);
                if (json.optBoolean("active")) {
                    JSONObject jSONObject = json;
                    return jSONObject;
                }
                throw new Exception("Authentication failed. Verification of returned token failed.");
            }
            throw new Exception("Authentication failed. Status code of verification was " + response.code());
        }
        finally {
            response.body().close();
        }
    }
}

