/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.resources;

import com.ibm.cloud.urbancode.sync.cloud.CloudSocketComponent;
import com.ibm.cloud.urbancode.sync.resources.LoginVerification;
import com.ibm.cloud.urbancode.sync.util.UsersUtil;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.apache.wink.json4j.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@Path(value="/login")
public class LoginResource {
    public static final Logger log = LoggerFactory.getLogger(LoginResource.class);
    @Autowired
    private CloudSocketComponent socketService;
    @Value(value="${registrationUrl}")
    private String registrationUrl;
    @Autowired
    private LoginVerification loginVerification;

    @GET
    public Response loging(@Context UriInfo uriInfo) throws URISyntaxException {
        if (this.socketService.isRegistered()) {
            URI callbackUrl = uriInfo.getBaseUriBuilder().path("login").path("callback").build(new Object[0]);
            URI uri = UriBuilder.fromUri((String)this.registrationUrl).path("auth").path("login").queryParam("redirectUrl", new Object[]{callbackUrl}).build(new Object[0]);
            return Response.seeOther((URI)uri).build();
        }
        URI uri = UriBuilder.fromPath((String)"/register").build(new Object[0]);
        return Response.seeOther((URI)uri).build();
    }

    @GET
    @Path(value="/callback")
    public Response callback(@Context HttpServletRequest request) throws Exception {
        if (this.socketService.isRegistered()) {
            String accessToken = request.getParameter("accessToken");
            if (StringUtils.isBlank((CharSequence)accessToken)) {
                URI uri = UriBuilder.fromPath((String)"/login").build(new Object[0]);
                return Response.seeOther((URI)uri).build();
            }
            JSONObject json = this.loginVerification.verify(accessToken);
            String user = json.getString("sub");
            if (UsersUtil.isUserAllowed(user)) {
                log.info(user + " logged in.");
                request.getSession().setAttribute("user", (Object)user);
                request.getSession().setAttribute("userInfo", (Object)json.toString());
                URI uri = UriBuilder.fromPath((String)"/").build(new Object[0]);
                return Response.seeOther((URI)uri).build();
            }
            log.warn(user + " logged in but is not an allowed user.");
            throw new WebApplicationException("Not allowed", 403);
        }
        URI uri = UriBuilder.fromPath((String)"/register").build(new Object[0]);
        return Response.seeOther((URI)uri).build();
    }
}

