/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.resources;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ibm.cloud.urbancode.sync.models.Integration;
import com.ibm.cloud.urbancode.sync.persistence.cloud.ConnectorPluginCloudDao;
import com.ibm.cloud.urbancode.sync.persistence.cloud.IntegrationCloudDao;
import com.ibm.cloud.urbancode.sync.plugin.Command;
import com.ibm.cloud.urbancode.sync.plugin.IntegrationService;
import com.ibm.cloud.urbancode.sync.plugin.Plugin;
import com.ibm.cloud.urbancode.sync.plugin.PluginHelper;
import com.ibm.cloud.urbancode.sync.plugin.UIFieldDefinition;
import com.ibm.cloud.urbancode.sync.plugin.quartz.IntegrationRunner;
import com.ibm.cloud.urbancode.sync.resources.CSResource;
import com.ibm.cloud.urbancode.sync.resources.json.Association;
import com.ibm.cloud.urbancode.sync.resources.json.JsonSerializer;
import com.ibm.cloud.urbancode.sync.resources.json.Updater;
import com.urbancode.air.property.prop_def.PropDef;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.UUID;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="/integrations")
@Component(value="IntegrationsResource")
public class IntegrationsResource
extends CSResource<Integration> {
    public static final Logger log = LoggerFactory.getLogger(IntegrationsResource.class);
    private IntegrationCloudDao dao;
    private ConnectorPluginCloudDao pluginDao;
    private PluginHelper pluginHelper;
    private IntegrationService service;

    @Inject
    public IntegrationsResource(ConnectorPluginCloudDao pluginDao, PluginHelper pluginHelper, IntegrationCloudDao dao, IntegrationService service) {
        this.pluginDao = pluginDao;
        this.pluginHelper = pluginHelper;
        this.dao = dao;
        this.service = service;
    }

    @GET
    @Path(value="/type")
    @Produces(value={"application/json"})
    public String getPluginTypes() {
        JsonArray result = new JsonArray();
        List plugins = this.pluginDao.getAll();
        if (plugins != null) {
            for (Plugin plugin : plugins) {
                JsonObject pluginObject = new JsonObject();
                pluginObject.addProperty("name", plugin.getName());
                pluginObject.addProperty("value", plugin.getPluginId());
                pluginObject.addProperty("version", (Number)plugin.getPluginVersion());
                pluginObject.addProperty("plugin", plugin.getId().toString());
                pluginObject.add("properties", (JsonElement)new JsonObject());
                result.add((JsonElement)pluginObject);
            }
        }
        return result.toString();
    }

    @GET
    @Produces(value={"application/json"})
    public String getAll() throws Exception {
        List integrations = this.dao.getAll();
        JsonArray result = new JsonArray();
        JsonSerializer serial = new JsonSerializer(null, new Association(Integration.class, "plugin"));
        JsonParser parser = new JsonParser();
        if (integrations != null) {
            for (Integration integration : integrations) {
                JsonObject jo = parser.parse(serial.toJson(integration)).getAsJsonObject();
                parser.parse(serial.toJson(integration));
                this.addPropSheetToJson(integration, jo);
                result.add((JsonElement)jo);
            }
        }
        return IntegrationsResource.stripBidi(result.toString());
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Response get(@PathParam(value="id") String id) throws Exception {
        Integration model = (Integration)this.dao.get(UUID.fromString(id));
        return Response.ok((Object)this.integrationToJson(model)).build();
    }

    private String integrationToJson(Integration integration) {
        JsonSerializer serial = new JsonSerializer(null, new Association(Integration.class, "plugin"));
        JsonParser parser = new JsonParser();
        JsonObject jo = parser.parse(serial.toJson(integration)).getAsJsonObject();
        parser.parse(serial.toJson(integration));
        this.addPropSheetToJson(integration, jo);
        jo.add("properties", jo.get("propSheet"));
        jo.remove("propSheet");
        return IntegrationsResource.stripBidi(jo.toString());
    }

    @DELETE
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Response delete(@PathParam(value="id") String id) throws Exception {
        Integration integration = (Integration)this.dao.get(UUID.fromString(id));
        this.dao.delete(integration);
        this.service.unschedule(integration);
        return Response.noContent().build();
    }

    @POST
    @Consumes(value={"application/json"})
    public Response createIntegration(String json) {
        JsonElement jsonElem = new JsonParser().parse(json);
        JsonObject jsonObj = jsonElem.getAsJsonObject();
        Integration integration = new Integration();
        new Updater(this.pluginDao).update((Object)integration, jsonObj);
        this.updatePropSheetAndIntegrationProviderFromJson(integration, jsonObj, false);
        this.dao.create(integration);
        try {
            this.service.schedule(integration);
        }
        catch (Exception e) {
            log.error("Error scheduling integration " + integration.toString(), (Throwable)e);
        }
        URI uri = UriBuilder.fromPath((String)"/integrations").path("/{id}").build(new Object[]{integration.getId()});
        String entity = this.integrationToJson(integration);
        return Response.created((URI)uri).entity((Object)entity).build();
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    public Response updateIntegration(@PathParam(value="id") String id, String json) {
        Integration integration = (Integration)this.dao.get(UUID.fromString(id));
        JsonElement jsonElem = new JsonParser().parse(json);
        JsonObject jsonObj = jsonElem.getAsJsonObject();
        new Updater(this.pluginDao).update((Object)integration, jsonObj);
        this.updatePropSheetAndIntegrationProviderFromJson(integration, jsonObj, true);
        this.dao.update(integration);
        try {
            this.service.schedule(integration);
        }
        catch (Exception e) {
            log.error("Error scheduling integration " + integration.toString(), (Throwable)e);
        }
        String entity = this.integrationToJson(integration);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)entity).build();
    }

    @GET
    @Path(value="{id}/versions")
    @Produces(value={"application/json"})
    public String getPlugin(@PathParam(value="id") String id) {
        JsonArray result = new JsonArray();
        try {
            Plugin p = (Plugin)this.pluginDao.get(UUID.fromString(id));
            ArrayList<Plugin> plugins = new ArrayList<Plugin>();
            plugins.add(p);
            JsonParser parser = new JsonParser();
            for (Plugin plugin : plugins) {
                JsonObject pluginObject = new JsonObject();
                JsonSerializer serial = new JsonSerializer(null, new Association(UIFieldDefinition.class, "propDef"), new Association(PropDef.class, "allowedValues"));
                SortedSet<UIFieldDefinition> fields = plugin.getDefaultDisplayableStep().getUICommandDefinition().getFields();
                JsonArray uiFieldDefArr = new JsonArray();
                for (UIFieldDefinition field : fields) {
                    uiFieldDefArr.add(parser.parse(serial.toJson(field)));
                }
                pluginObject.addProperty("name", plugin.getName());
                pluginObject.addProperty("version", (Number)plugin.getPluginVersion());
                pluginObject.addProperty("plugin", plugin.getId().toString());
                pluginObject.add("properties", (JsonElement)new JsonObject());
                pluginObject.addProperty("description", plugin.getDescription());
                pluginObject.add("pluginProperties", (JsonElement)uiFieldDefArr);
                result.add((JsonElement)pluginObject);
            }
        }
        catch (Exception e) {
            log.error("Error processing plugins", (Throwable)e);
        }
        return result.toString();
    }

    @GET
    @Path(value="{versionId}/steps")
    @Produces(value={"application/json"})
    public String getAllStepsForVersion(@PathParam(value="versionId") String id) {
        JsonArray result = new JsonArray();
        JsonParser parser = new JsonParser();
        Plugin p = (Plugin)this.pluginDao.get(UUID.fromString(id));
        SortedSet<Command> commands = p.getCommands();
        for (Command command : commands) {
            if (!command.isDisplayed()) continue;
            JsonSerializer serial = new JsonSerializer(null, new Association(UIFieldDefinition.class, "propDef"), new Association(PropDef.class, "allowedValues"));
            SortedSet<UIFieldDefinition> fields = command.getUICommandDefinition().getFields();
            JsonArray uiFieldDefArr = new JsonArray();
            for (UIFieldDefinition field : fields) {
                uiFieldDefArr.add(parser.parse(serial.toJson(field)));
            }
            JsonObject commandJson = new JsonObject();
            commandJson.addProperty("name", command.getName());
            commandJson.add("pluginProperties", (JsonElement)uiFieldDefArr);
            result.add((JsonElement)commandJson);
        }
        return result.toString();
    }

    @GET
    @Path(value="{pluginId}/{commandName}/resolveValues/{propDefName}/")
    @Produces(value={"application/json"})
    public String resolveTransientPropertyValues(@PathParam(value="propDefName") String propDefName, @PathParam(value="pluginId") String pluginId, @PathParam(value="commandName") String commandName, @QueryParam(value="label") String labelFilter, @HeaderParam(value="Range") String range, @Context HttpServletResponse response, @Context UriInfo allQueryParams, @Context HttpHeaders allHeaderParams) {
        JsonArray result = new JsonArray();
        Integration provider = null;
        Plugin plugin = (Plugin)this.pluginDao.get(UUID.fromString(pluginId));
        try {
            result = this.pluginHelper.resolveExternalPropertiesValues(provider, propDefName, plugin, commandName, labelFilter, range, response, allQueryParams, allHeaderParams);
        }
        catch (Exception e) {
            log.error("Error evaluating plugin property '" + propDefName + "' for plugin '" + plugin.getName() + "' with command '" + commandName + "'", (Throwable)e);
            throw new WebApplicationException("Error evaluating plugin property '" + propDefName + "'");
        }
        return result.toString();
    }

    @GET
    @Path(value="{integrationId}/{pluginId}/{commandName}/resolveValues/{propDefName}/")
    @Produces(value={"application/json"})
    public String resolvePropertyValues(@PathParam(value="propDefName") String propDefName, @PathParam(value="integrationId") String integrationId, @PathParam(value="pluginId") String pluginId, @PathParam(value="commandName") String commandName, @QueryParam(value="label") String labelFilter, @HeaderParam(value="Range") String range, @Context HttpServletResponse response, @Context UriInfo allQueryParams, @Context HttpHeaders allHeaderParams) {
        JsonArray result = new JsonArray();
        Integration provider = (Integration)this.dao.get(UUID.fromString(integrationId));
        Plugin plugin = (Plugin)this.pluginDao.get(UUID.fromString(pluginId));
        try {
            result = this.pluginHelper.resolveExternalPropertiesValues(provider, propDefName, plugin, commandName, labelFilter, range, response, allQueryParams, allHeaderParams);
        }
        catch (Exception e) {
            log.error("Error evaluating integration property '" + propDefName + "' for plugin '" + plugin.getName() + "' with command '" + commandName + "' for integration '" + integrationId, (Throwable)e);
            throw new WebApplicationException("Error evaluating integration property '" + propDefName + "'");
        }
        return result.toString();
    }

    @POST
    @Path(value="execute")
    public Response runIntegration(@FormParam(value="integrationProviderId") String integrationProviderId) throws Exception {
        JsonObject result = null;
        UUID uuid = UUID.fromString(integrationProviderId);
        Integration provider = (Integration)this.dao.get(uuid);
        if (provider == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        IntegrationRunner job = new IntegrationRunner(this.dao, uuid, this.pluginHelper);
        job.run();
        result = job.getJobResult();
        return Response.ok().entity((Object)result).build();
    }
}

