/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.resources;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.ibm.cloud.urbancode.sync.resources.Format;
import com.ibm.cloud.urbancode.sync.resources.json.AssocExclusionStrategy;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class GsonFormat<T>
extends Format<T> {
    protected Map<Type, Object> typeAdapters = new HashMap<Type, Object>();
    private Gson gson;

    protected Gson getGson() {
        if (this.gson != null) {
            return this.gson;
        }
        GsonBuilder gBuilder = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new AssocExclusionStrategy(this.getOutputAssociations()));
        for (Map.Entry<Type, Object> entry : this.typeAdapters.entrySet()) {
            gBuilder.registerTypeAdapter(entry.getKey(), entry.getValue());
        }
        this.gson = gBuilder.create();
        return this.gson;
    }

    @Override
    public JsonObject buildJson(T model) {
        return this.getGson().toJsonTree(model).getAsJsonObject();
    }
}

