/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.resources;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.ibm.cloud.urbancode.sync.resources.json.Association;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class Format<T>
implements JsonSerializer<T> {
    protected Association[] outputAssociations = new Association[0];
    protected Association[] joinOnlyAssociations = new Association[0];

    public JsonElement serialize(T model, Type modelType, JsonSerializationContext context) {
        return this.buildJson(model);
    }

    public List<Association> getOutputAssociations() {
        return Arrays.asList(this.outputAssociations);
    }

    public List<Association> getJoinAssociations() {
        ArrayList<Association> associations = new ArrayList<Association>(this.outputAssociations.length + this.joinOnlyAssociations.length);
        associations.addAll(this.getOutputAssociations());
        associations.addAll(Arrays.asList(this.joinOnlyAssociations));
        return associations;
    }

    public String writeJson(T model) {
        return this.buildJson(model).toString();
    }

    public abstract JsonObject buildJson(T var1);

    public JsonArray buildJson(Iterable<? extends T> models) {
        JsonArray ja = new JsonArray();
        for (T model : models) {
            ja.add((JsonElement)this.buildJson(model));
        }
        return ja;
    }
}

