/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ibm.cloud.urbancode.sync.models.CSEntity;
import com.ibm.cloud.urbancode.sync.models.WithPropSheet;
import com.ibm.cloud.urbancode.sync.models.WithPropSheetDef;
import com.urbancode.air.property.prop_def.PropDef;
import com.urbancode.air.property.prop_sheet.PropSheet;
import com.urbancode.air.property.prop_sheet_def.PropSheetDef;
import com.urbancode.air.property.prop_value.PropValue;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class CSResource<T extends CSEntity> {
    protected static final String propSheetName = "propSheet";
    public static final String LAST_PROP_EDIT = "lastPropertyEdit";

    protected void updatePropSheetAndIntegrationProviderFromJson(T model, JsonObject json, boolean updating) {
        if (model instanceof WithPropSheet) {
            CSResource.updatePropSheetFromJson((WithPropSheet)model, json);
        }
    }

    public static void updatePropSheetFromJson(WithPropSheet model, JsonObject json) {
        String propPrefix = "propSheet/";
        boolean updatedProperties = CSResource.updatePropSheetFromJson(model, json, propPrefix);
        if (json.has("properties") && !updatedProperties) {
            JsonObject jsonProperties = json.get("properties").getAsJsonObject();
            CSResource.updatePropSheetFromJson(model, jsonProperties, null);
        }
    }

    public static boolean updatePropSheetFromJson(WithPropSheet model, JsonObject json, String propPrefix) {
        boolean updatedProperties = false;
        PropSheet propSheet = model.getPropSheet();
        PropSheetDef propSheetDef = null;
        if (model instanceof WithPropSheetDef) {
            propSheetDef = ((WithPropSheetDef)((Object)model)).getPropSheetDef();
        }
        for (Map.Entry entry : json.entrySet()) {
            String propName = (String)entry.getKey();
            if (propPrefix != null) {
                if (!propName.startsWith(propPrefix)) continue;
                propName = propName.substring(propPrefix.length());
            }
            String propValue = null;
            if (entry.getValue() != null) {
                propValue = ((JsonElement)entry.getValue()).getAsString();
            }
            String oldPropValue = propSheet.getPropValue(propName);
            PropDef propDef = null;
            if (propSheetDef != null) {
                propDef = propSheetDef.getPropDef(propName);
            }
            if (propDef != null && propDef.isSecure()) {
                if (!StringUtils.equals((CharSequence)propValue, (CharSequence)"****")) {
                    propSheet.setSecurePropValue(propName, propValue);
                }
            } else {
                propSheet.setPropValue(propName, propValue);
            }
            if (propValue != null) {
                if (propName.equals(LAST_PROP_EDIT) || propValue.equals(oldPropValue)) continue;
                updatedProperties = true;
                continue;
            }
            if (oldPropValue == null || propName.equals(LAST_PROP_EDIT)) continue;
            updatedProperties = true;
        }
        if (updatedProperties) {
            propSheet.setPropValue(LAST_PROP_EDIT, System.currentTimeMillis() + "");
        }
        return updatedProperties;
    }

    protected void addPropSheetToJson(WithPropSheet model, JsonObject json) {
        PropSheet propSheet = model.getPropSheet();
        JsonObject properties = new JsonObject();
        json.add(propSheetName, (JsonElement)properties);
        for (PropValue propValue : propSheet.getPropValueList()) {
            String propName = propValue.getName();
            String value = "****";
            if (!propValue.isSecure().booleanValue()) {
                value = propValue.getValue();
            }
            properties.addProperty(propName, value);
            json.addProperty("propSheet/" + propName, value);
        }
    }

    public static String stripBidi(String s) {
        if (s == null) {
            return s;
        }
        return s.replaceAll("\u202a", "").replaceAll("\u202b", "").replaceAll("\u202c", "");
    }
}

