/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.plugin.quartz;

import com.ibm.cloud.urbancode.sync.plugin.quartz.AutowiringSpringBeanJobFactory;
import com.ibm.cloud.urbancode.sync.plugin.quartz.IntegrationRunner;
import com.ibm.cloud.urbancode.sync.plugin.quartz.JobSchedulerFactory;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.quartz.Trigger;
import org.quartz.spi.JobFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.quartz.JobDetailFactoryBean;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

@Configuration
public class QuartzConfig {
    private final Logger log = LoggerFactory.getLogger((String)this.getClass().getSimpleName());
    @Autowired
    private ApplicationContext applicationContext;

    @PostConstruct
    public void init() {
        this.log.debug("QuartzConfig initialized.");
    }

    @Bean
    public SchedulerFactoryBean schedulerFactory() {
        SchedulerFactoryBean schedulerFactory = new SchedulerFactoryBean();
        schedulerFactory.setOverwriteExistingJobs(true);
        schedulerFactory.setSchedulerName("integration-scheduler");
        AutowiringSpringBeanJobFactory jobFactory = new AutowiringSpringBeanJobFactory();
        jobFactory.setApplicationContext(this.applicationContext);
        schedulerFactory.setJobFactory((JobFactory)jobFactory);
        schedulerFactory.setQuartzProperties(this.quartzProperties());
        Trigger[] triggers = new Trigger[]{};
        schedulerFactory.setTriggers(triggers);
        return schedulerFactory;
    }

    @Bean
    public JobDetailFactoryBean jobDetailFactory() {
        JobDetailFactoryBean jobDetailFactory = new JobDetailFactoryBean();
        jobDetailFactory.setJobClass(IntegrationRunner.class);
        jobDetailFactory.setGroup(JobSchedulerFactory.TASK_GROUP_INTEGRATION);
        return jobDetailFactory;
    }

    @Bean
    public Properties quartzProperties() {
        return JobSchedulerFactory.initProperties();
    }
}

