/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.plugin.quartz;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.UnableToInterruptJobException;
import org.quartz.impl.matchers.GroupMatcher;
import org.springframework.stereotype.Component;

@Component(value="JobSchedulerFactory")
public class JobSchedulerFactory {
    private static final Logger log = Logger.getLogger(JobSchedulerFactory.class);
    private static final String INSTANCE_NAME = "org.quartz.scheduler.instanceName";
    private static final String INSTANCE_ID = "org.quartz.scheduler.instanceId";
    private static final String SKIP_UPDATE_CHECK = "org.quartz.scheduler.skipUpdateCheck";
    private static final String THREAD_POOL_CLASS = "org.quartz.threadPool.class";
    private static final String THREAD_POOL_COUNT = "org.quartz.threadPool.threadCount";
    private static final String THREAD_POOL_PRIORITY = "org.quartz.threadPool.threadPriority";
    private static final String JOB_STORE_MISFIRE_THRESHOLD = "org.quartz.jobStore.misfireThreshold";
    private static final String JOB_STORE_CLASS = "org.quartz.jobStore.class";
    public static String TASK_GROUP_INTEGRATION = "IntegrationProviderTasksGroup";
    private Scheduler scheduler = null;

    @Inject
    public JobSchedulerFactory(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public static Properties initProperties() {
        Properties props = new Properties();
        props.put(INSTANCE_NAME, "JobScheduler");
        props.put(INSTANCE_ID, "AUTO");
        props.put(SKIP_UPDATE_CHECK, "true");
        props.put(THREAD_POOL_CLASS, "org.quartz.simpl.SimpleThreadPool");
        props.put(THREAD_POOL_COUNT, "10");
        props.put(THREAD_POOL_PRIORITY, "5");
        props.put(JOB_STORE_MISFIRE_THRESHOLD, "60000");
        props.put(JOB_STORE_CLASS, "org.quartz.simpl.RAMJobStore");
        return props;
    }

    public void createOrUpdateCronTrigger(UUID id, Class<? extends Job> jobClass, String group, String cronExpression, JobDataMap jobDataMap) throws Exception {
        String jobKey = id.toString();
        JobDetail job = JobBuilder.newJob(jobClass).withIdentity(jobKey, group).build();
        job.getJobDataMap().putAll((Map)jobDataMap);
        if (!this.scheduler.checkExists(new JobKey(jobKey, group))) {
            CronTrigger trigger = this.newCronTrigger(cronExpression, jobKey, group);
            this.scheduler.scheduleJob(job, (Trigger)trigger);
        } else {
            CronTrigger triggerDetails = (CronTrigger)this.scheduler.getTrigger(new TriggerKey(jobKey, group));
            if (!triggerDetails.getCronExpression().equals(cronExpression)) {
                this.rescheduleJobWithNewCronExpression(triggerDetails, cronExpression);
            }
        }
    }

    public void createOrUpdateSimpleTrigger(UUID id, Class<? extends Job> jobClass, String group, long date, JobDataMap jobDataMap) throws Exception {
        this.createOrUpdateSimpleTrigger(id.toString(), jobClass, group, date, jobDataMap);
    }

    public void createOrUpdateSimpleTrigger(String id, Class<? extends Job> jobClass, String group, long date, JobDataMap jobDataMap) throws Exception {
        this.createOrUpdateSimpleTrigger(id, jobClass, group, date, jobDataMap, true);
    }

    public void createOrUpdateSimpleTrigger(String id, Class<? extends Job> jobClass, String group, long date, JobDataMap jobDataMap, boolean createIfDoesNotExist) throws Exception {
        String jobKey = id.toString();
        JobDetail job = JobBuilder.newJob(jobClass).withIdentity(jobKey, group).build();
        job.getJobDataMap().putAll((Map)jobDataMap);
        if (!this.scheduler.checkExists(new JobKey(jobKey, group))) {
            if (createIfDoesNotExist) {
                SimpleTrigger trigger = this.newSimpleTrigger(jobKey, group, date, false);
                this.scheduler.scheduleJob(job, (Trigger)trigger);
            }
        } else {
            SimpleTrigger triggerDetails = (SimpleTrigger)this.scheduler.getTrigger(new TriggerKey(jobKey, group));
            if (triggerDetails.getStartTime().getTime() != date) {
                this.rescheduleJobWithNewStartDate(triggerDetails, date);
            }
        }
    }

    public void createOrUpdateTriggerAndStartJobNow(String key, Class<? extends Job> jobClass, String group, JobDataMap jobDataMap) throws Exception {
        JobDetail job = JobBuilder.newJob(jobClass).withIdentity(key, group).build();
        job.getJobDataMap().putAll((Map)jobDataMap);
        if (!this.scheduler.checkExists(new JobKey(key, group))) {
            SimpleTrigger trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity(key, group).startNow().build();
            this.scheduler.scheduleJob(job, (Trigger)trigger);
        } else {
            SimpleTrigger oldTrigger = (SimpleTrigger)this.scheduler.getTrigger(new TriggerKey(key, group));
            TriggerBuilder tb = oldTrigger.getTriggerBuilder();
            SimpleTrigger newTrigger = (SimpleTrigger)tb.startNow().build();
            this.scheduler.rescheduleJob(oldTrigger.getKey(), (Trigger)newTrigger);
        }
    }

    public void createOrUpdateSimpleTrigger(UUID id, Class<? extends Job> jobClass, String group, int frequency, JobDataMap jobDataMap) throws Exception {
        String jobKey = id.toString();
        this.createOrUpdateSimpleTrigger(jobKey, jobClass, group, frequency, jobDataMap);
    }

    public void createOrUpdateSimpleTrigger(String jobKey, Class<? extends Job> jobClass, String group, int frequency, JobDataMap jobDataMap) throws Exception {
        JobDetail job = JobBuilder.newJob(jobClass).withIdentity(jobKey, group).build();
        job.getJobDataMap().putAll((Map)jobDataMap);
        if (!this.scheduler.checkExists(new JobKey(jobKey, group))) {
            if (frequency != 0) {
                SimpleTrigger trigger = this.newSimpleTrigger(jobKey, group, frequency, true);
                this.scheduler.scheduleJob(job, (Trigger)trigger);
            }
        } else if (frequency != 0) {
            SimpleTrigger triggerDetails = (SimpleTrigger)this.scheduler.getTrigger(new TriggerKey(jobKey, group));
            if (triggerDetails.getRepeatInterval() != (long)(frequency * 60 * 1000)) {
                this.rescheduleJobWithNewFrequency(triggerDetails, frequency);
            }
        } else {
            this.resetScheduledJobByKey(new JobKey(jobKey, group));
        }
    }

    public SimpleTrigger newSimpleTrigger(String jobKey, String jobGroup, int frequency, boolean ignoreMisfires) {
        SimpleTrigger trigger = null;
        trigger = ignoreMisfires ? (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity(jobKey, jobGroup).startAt(new Date(System.currentTimeMillis())).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMinutes(frequency).repeatForever().withRepeatCount(-1).withMisfireHandlingInstructionFireNow()).build() : (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity(jobKey, jobGroup).startAt(new Date(System.currentTimeMillis())).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMinutes(frequency).repeatForever().withRepeatCount(-1).withMisfireHandlingInstructionIgnoreMisfires()).build();
        return trigger;
    }

    public SimpleTrigger newSimpleTrigger(String jobKey, String jobGroup, boolean ignoreMisfires) {
        SimpleTrigger trigger = null;
        trigger = ignoreMisfires ? (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity(jobKey, jobGroup).startAt(new Date(System.currentTimeMillis())).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withMisfireHandlingInstructionFireNow()).build() : (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity(jobKey, jobGroup).startAt(new Date(System.currentTimeMillis())).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withMisfireHandlingInstructionIgnoreMisfires()).build();
        return trigger;
    }

    public SimpleTrigger newSimpleTrigger(String jobKey, String jobGroup, long date, boolean ignoreMisfires) {
        SimpleTrigger trigger = null;
        trigger = ignoreMisfires ? (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity(jobKey, jobGroup).startAt(new Date(date)).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withMisfireHandlingInstructionFireNow()).build() : (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity(jobKey, jobGroup).startAt(new Date(date)).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withMisfireHandlingInstructionIgnoreMisfires()).build();
        return trigger;
    }

    public CronTrigger newCronTrigger(String cronExpression, String jobKey, String jobGroup) {
        CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(jobKey, jobGroup).startAt(new Date(System.currentTimeMillis())).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).build();
        return trigger;
    }

    public void rescheduleJobWithNewFrequency(SimpleTrigger oldTrigger, int frequency) throws Exception {
        TriggerBuilder tb = oldTrigger.getTriggerBuilder();
        SimpleTrigger newTrigger = (SimpleTrigger)tb.withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMinutes(frequency).repeatForever()).build();
        this.scheduler.rescheduleJob(oldTrigger.getKey(), (Trigger)newTrigger);
    }

    public void rescheduleJobWithNewStartDate(SimpleTrigger oldTrigger, long date) throws Exception {
        TriggerBuilder tb = oldTrigger.getTriggerBuilder();
        SimpleTrigger newTrigger = (SimpleTrigger)tb.startAt(new Date(date)).build();
        this.scheduler.rescheduleJob(oldTrigger.getKey(), (Trigger)newTrigger);
    }

    public void rescheduleJobWithNewCronExpression(CronTrigger oldTrigger, String cronExpression) throws Exception {
        TriggerBuilder tb = oldTrigger.getTriggerBuilder();
        CronTrigger newTrigger = (CronTrigger)tb.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).build();
        this.scheduler.rescheduleJob(oldTrigger.getKey(), (Trigger)newTrigger);
    }

    public void resetScheduledJobByGroup(String group) {
        try {
            for (JobKey jobKey : this.scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)group))) {
                List triggers = this.getScheduler().getTriggersOfJob(jobKey);
                for (Trigger x : triggers) {
                    this.scheduler.unscheduleJob(x.getKey());
                }
                this.scheduler.deleteJob(jobKey);
            }
        }
        catch (SchedulerException e) {
            log.error((Object)"Can not delete the scheduled jobs", (Throwable)e);
        }
    }

    public void resetScheduledJobByGroupAndKeyThatStartsWith(String group, String name) {
        try {
            for (JobKey jobKey : this.scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)group))) {
                if (!jobKey.getName().startsWith(name)) continue;
                List triggers = this.getScheduler().getTriggersOfJob(jobKey);
                for (Trigger trigger : triggers) {
                    this.scheduler.unscheduleJob(trigger.getKey());
                    this.scheduler.deleteJob(jobKey);
                }
            }
        }
        catch (SchedulerException e) {
            log.error((Object)"Can not delete the scheduled jobs", (Throwable)e);
        }
    }

    public void resetScheduledJobByGroup(String group, long timeStamp) {
        try {
            for (JobKey jobKey : this.scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)group))) {
                List triggers = this.getScheduler().getTriggersOfJob(jobKey);
                for (Trigger x : triggers) {
                    if (!x.getNextFireTime().before(new Date(timeStamp))) continue;
                    this.scheduler.unscheduleJob(x.getKey());
                    this.scheduler.deleteJob(jobKey);
                }
            }
        }
        catch (SchedulerException e) {
            log.error((Object)"Can not delete the scheduled jobs", (Throwable)e);
        }
    }

    public void resetScheduledJobByKey(JobKey jobKey) {
        try {
            List triggers = this.getScheduler().getTriggersOfJob(jobKey);
            for (Trigger x : triggers) {
                this.scheduler.unscheduleJob(x.getKey());
            }
            this.scheduler.deleteJob(jobKey);
        }
        catch (SchedulerException e) {
            log.error((Object)"Can not delete the scheduled job", (Throwable)e);
        }
    }

    public boolean resetScheduledJob(String id, String group) {
        boolean jobRemoved = false;
        try {
            JobKey jobKey = new JobKey(id, group);
            TriggerKey triggerKey = new TriggerKey(id, group);
            if (this.scheduler.checkExists(jobKey)) {
                log.debug((Object)("This job will be deleted " + id + " " + group));
                this.scheduler.getTrigger(new TriggerKey(id, group));
                this.scheduler.unscheduleJob(triggerKey);
                this.scheduler.deleteJob(jobKey);
                jobRemoved = true;
            }
        }
        catch (SchedulerException e) {
            log.error((Object)"Can not delete the scheduled job", (Throwable)e);
        }
        return jobRemoved;
    }

    public void interruptRunningJob(String id, String group) {
        JobKey jobKey = new JobKey(id, group);
        try {
            if (this.scheduler.checkExists(jobKey)) {
                log.debug((Object)("This job will be stopped " + id + " " + group));
                this.scheduler.interrupt(jobKey);
            }
        }
        catch (UnableToInterruptJobException e) {
            log.error((Object)e);
        }
        catch (SchedulerException e) {
            log.error((Object)e);
        }
    }

    public String buildValidCronExpression(String rule) {
        try {
            CronExpression.validateExpression((String)rule);
        }
        catch (Exception ex) {
            rule = null;
            log.error((Object)"Can not convert this rule to a valid cron expression");
        }
        return rule;
    }

    public long nbJobStillRunning(String jobName) {
        return this.nbJobStillRunningSingleInstance(jobName);
    }

    public long nbJobStillRunningSingleInstance(String jobName) {
        long nbJobs = 0L;
        try {
            List jobs = this.getScheduler().getCurrentlyExecutingJobs();
            if (!jobs.isEmpty()) {
                for (JobExecutionContext job : jobs) {
                    if (job.getJobDetail() == null || job.getJobDetail().getKey().getName() == null || !job.getJobDetail().getKey().getName().equals(jobName)) continue;
                    ++nbJobs;
                }
            }
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
        return nbJobs;
    }

    public void displayTriggerDetails(SimpleTrigger trigger) {
        log.debug((Object)("Next Trigger time : " + trigger.getNextFireTime()));
        log.debug((Object)("Frequency : " + trigger.getRepeatInterval()));
    }

    public void showQuartzConfigurationForDebug(Properties props) {
        log.debug((Object)"---- Quartz Properties ----");
        for (String key : props.stringPropertyNames()) {
            String value = props.getProperty(key);
            log.debug((Object)(key + " => " + value));
        }
        log.debug((Object)"---- ----------------- ----");
    }
}

