/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.plugin.quartz;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ibm.cloud.urbancode.sync.models.Integration;
import com.ibm.cloud.urbancode.sync.persistence.cloud.IntegrationCloudDao;
import com.ibm.cloud.urbancode.sync.plugin.Command;
import com.ibm.cloud.urbancode.sync.plugin.PluginHelper;
import com.ibm.cloud.urbancode.sync.plugin.connector.ConnectorPlugin;
import com.ibm.cloud.urbancode.sync.plugin.quartz.InvalidJobException;
import com.urbancode.air.i18n.TranslateUtil;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class IntegrationRunner
extends Thread
implements Job {
    private static final Logger log = Logger.getLogger(IntegrationRunner.class);
    private UUID integrationId;
    private boolean executionResult = false;
    private JobExecutionContext context;
    private Integration integration;
    private String currentState;
    private String lastExecutionReport;
    private String lastExecutionStatus;
    private long lastExecution;
    @Autowired
    private IntegrationCloudDao dao;
    @Autowired
    private PluginHelper pluginHelper;

    public IntegrationRunner() {
    }

    @Inject
    public IntegrationRunner(IntegrationCloudDao integrationsDao, UUID integrationId, PluginHelper pluginHelper) {
        this.dao = integrationsDao;
        this.integrationId = integrationId;
        this.pluginHelper = pluginHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        this.context = context;
        JobDetail jobDetail = context.getJobDetail();
        JobDataMap data = jobDetail.getJobDataMap();
        this.integrationId = (UUID)data.get((Object)"UUID");
        if (!this.pluginHelper.isIntegrationRunning(this.integrationId).booleanValue()) {
            try {
                this.pluginHelper.setIntegrationToRunning(this.integrationId);
                this.run();
            }
            catch (InvalidJobException e) {
                log.error((Object)("Removing invalid scheduled integration " + this.integrationId + " ..."));
                try {
                    context.getScheduler().deleteJob(jobDetail.getKey());
                    log.error((Object)"Removed invalid scheduled integration");
                }
                catch (SchedulerException se) {
                    log.error((Object)"Error removing invalid scheduled integration", (Throwable)se);
                }
            }
            finally {
                this.pluginHelper.setIntegrationToNotRunning(this.integrationId);
            }
        } else {
            log.warn((Object)("A scheduled integration (" + jobDetail.getKey().getName() + "-" + jobDetail.getKey().getGroup() + ") is already running. Skipping."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.integration = (Integration)this.dao.get(this.integrationId);
        }
        catch (RuntimeException e) {
            log.error((Object)("Error restoring integration " + this.integrationId + " for run"), (Throwable)e);
            throw e;
        }
        if (this.integration == null) {
            log.error((Object)("Integration not found for scheduled action: " + this.integrationId));
            throw new InvalidJobException("Integration not found for scheduled action: " + this.integrationId);
        }
        long start = System.currentTimeMillis();
        log.info((Object)("Integration " + this.integration.getName() + " starting..."));
        this.integration.setCurrentState(Integration.CurrentStates.Running.toString());
        try {
            ConnectorPlugin plugin;
            Locale installationLocale = Locale.ENGLISH;
            TranslateUtil.getInstance().setCurrentLocale(installationLocale);
            DateFormat df = DateFormat.getDateTimeInstance(1, 1, installationLocale);
            this.integration = (Integration)this.dao.get(this.integrationId);
            this.lastExecution = new Date().getTime();
            this.integration.setExecutionReport(new ArrayList<String>());
            this.integration.addLog(Integration.LogType.TRACE.toString(), TranslateUtil.i18n((String)"Started at %s", (Object[])new Object[]{df.format(new Date())}));
            if (this.context != null && this.context.getNextFireTime() != null) {
                String nextTriggerInfo = TranslateUtil.i18n((String)"Next scheduled at %s", (Object[])new Object[]{this.context.getNextFireTime().toString()});
                log.debug((Object)nextTriggerInfo);
                this.integration.addLog(Integration.LogType.TRACE.toString(), nextTriggerInfo);
            }
            if ((plugin = this.integration.getPlugin()) == null) {
                throw new InvalidJobException("Plugin not found for integration " + this.integrationId + ". It can not run.");
            }
            Command commandToRun = plugin.getCommandByName(this.integration.getDefaultStep());
            if (commandToRun == null) {
                for (Command command : plugin.getCommands()) {
                    if (!command.isDisplayed()) continue;
                    commandToRun = command;
                }
            }
            if (commandToRun == null) {
                throw new InvalidJobException("Integration " + this.integrationId + " has no default command and plugin " + plugin.getId() + " has not commands marked as 'displayed'");
            }
            log.info((Object)("Running command '" + commandToRun.getName() + "' of plugin '" + plugin.getName() + " v" + plugin.getPluginVersion() + "'"));
            this.pluginHelper.executeStep(plugin, commandToRun, null, null, this.integration, false);
            long end = System.currentTimeMillis();
            this.integration.addLog(Integration.LogType.TRACE.toString(), TranslateUtil.i18n((String)"Duration: %s s", (Object[])new Object[]{(end - start) / 1000L}));
            this.integration.addLog(Integration.LogType.TRACE.toString(), TranslateUtil.i18n((String)"Finished at %s", (Object[])new Object[]{df.format(new Date())}));
            this.currentState = Integration.CurrentStates.Finished.toString();
            this.lastExecutionStatus = Integration.LastExecutionStatuses.Success.toString();
            this.lastExecutionReport = this.integration.getExecutionReport().toString();
            this.executionResult = true;
        }
        catch (Exception e) {
            this.integration.addLog(Integration.LogType.ERROR.toString(), TranslateUtil.i18n((String)"Error : %s", (Object[])new Object[]{e.getMessage()}));
            this.lastExecutionReport = this.integration.getExecutionReport().toString();
            this.currentState = Integration.CurrentStates.Finished.toString();
            this.lastExecutionStatus = Integration.LastExecutionStatuses.Failed.toString();
            log.error((Object)TranslateUtil.i18n((String)"Error running integration %s", (Object[])new Object[]{this.integration.getName()}), (Throwable)e);
            if (e instanceof InvalidJobException) {
                throw (InvalidJobException)e;
            }
        }
        finally {
            log.info((Object)("Integration " + this.integration.getName() + " done"));
        }
        this.synchronization();
    }

    public long nbPreviousJobStillRunning(UUID uuid) {
        long nbJobs = 0L;
        log.debug((Object)("Nb. jobs still running : " + nbJobs));
        return nbJobs;
    }

    private void synchronization() {
        try {
            this.integration = (Integration)this.dao.get(this.integrationId);
            this.integration.setLastExecution(this.lastExecution);
            this.integration.setLastExecutionReport(this.lastExecutionReport);
            this.integration.setCurrentState(this.currentState);
            this.integration.setLastExecutionStatus(this.lastExecutionStatus);
            this.dao.update(this.integration);
        }
        catch (Exception ex) {
            log.error((Object)("Could not save the integration info : " + ex.getMessage()));
        }
    }

    public JsonObject getJobResult() {
        JsonObject taskResult = new JsonObject();
        try {
            if (this.executionResult) {
                taskResult.addProperty("status", "Success");
            } else {
                taskResult.addProperty("status", "Failed");
            }
            JsonParser parser = new JsonParser();
            taskResult.add("message", parser.parse(TranslateUtil.i18n((String)this.integration.getLastExecutionReport().replaceAll("\\r\\n", "<br>").replaceAll("\\r", "<br>").replaceAll("\\n", "<br>"), (Object[])new Object[0])));
            taskResult.addProperty("lastExecution", (Number)this.integration.getLastExecution());
        }
        catch (Exception ex) {
            log.error((Object)(TranslateUtil.i18n((String)"Can not build the response ", (Object[])new Object[0]) + ex.getMessage()));
        }
        return taskResult;
    }
}

