/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.plugin.loader;

import com.urbancode.commons.util.IO;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class PluginSignatureValidator {
    public static final String PLUGIN_SIG_FILE = "plugin.sig";
    public static final String DIGEST_ALG = "SHA-256";
    private final ZipFile pluginFile;
    private final String signature;

    public PluginSignatureValidator(ZipFile pluginFile) throws IOException {
        this.pluginFile = pluginFile;
        InputStream sigStream = this.getInputStream(PLUGIN_SIG_FILE);
        this.signature = sigStream == null ? null : IO.readText((Reader)IO.reader((InputStream)sigStream));
    }

    public ZipFile getPluginFile() {
        return this.pluginFile;
    }

    public boolean isSigned() {
        return this.signature != null;
    }

    public final void validateSignature() throws GeneralSecurityException, IOException {
    }

    String convert64ToHex(String base64) {
        byte[] actualBytes = Base64.decodeBase64((byte[])base64.getBytes());
        String actualDigestHex = new String(Hex.encodeHex((byte[])actualBytes));
        return actualDigestHex;
    }

    InputStream getInputStream(String entryName) throws IOException {
        ZipEntry entry = this.getPluginFile().getEntry(entryName);
        if (entry == null) {
            return null;
        }
        return this.getPluginFile().getInputStream(entry);
    }
}

