/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.plugin.loader;

import com.ibm.cloud.urbancode.sync.models.Integration;
import com.ibm.cloud.urbancode.sync.persistence.cloud.ConnectorPluginCloudDao;
import com.ibm.cloud.urbancode.sync.persistence.cloud.IntegrationCloudDao;
import com.ibm.cloud.urbancode.sync.plugin.Command;
import com.ibm.cloud.urbancode.sync.plugin.Plugin;
import com.ibm.cloud.urbancode.sync.plugin.UICommandDefinition;
import com.ibm.cloud.urbancode.sync.plugin.UIFieldDefinition;
import com.ibm.cloud.urbancode.sync.plugin.connector.ConnectorPlugin;
import com.ibm.cloud.urbancode.sync.plugin.loader.PluginSignatureValidator;
import com.urbancode.air.plugin.server.ext.PluginExtension;
import com.urbancode.air.plugin.server.ext.PluginType;
import com.urbancode.air.plugin.server.ur.ext.URCommandExtension;
import com.urbancode.air.plugin.server.ur.ext.URPluginCommandGroupProperty;
import com.urbancode.air.plugin.server.ur.ext.URPluginCommandPropertyExtension;
import com.urbancode.air.plugin.server.xml.URServerPluginXmlParser;
import com.urbancode.air.plugin_command.AutomationPlugin;
import com.urbancode.air.plugin_command.properties.PluginCommandProperty;
import com.urbancode.air.plugin_command.properties.SelectValue;
import com.urbancode.air.plugin_command.schema_migration.SchemaValidationException;
import com.urbancode.air.plugin_command.upgrade.CommandUpgrade;
import com.urbancode.air.plugin_command.upgrade.PluginUpgrade;
import com.urbancode.air.plugin_command.upgrade.PluginVersionMigration;
import com.urbancode.air.plugin_command.upgrade.xml.PluginUpgradeMarshallEngine;
import com.urbancode.air.plugin_command.validation.PluginUpgradeValidator;
import com.urbancode.air.property.prop_def.PropDef;
import com.urbancode.air.property.prop_def.http.HttpPropInfo;
import com.urbancode.air.property.prop_def.scripted.ScriptedPropInfo;
import com.urbancode.air.property.prop_sheet_def.PropSheetDef;
import com.urbancode.commons.fileutils.FileUtils;
import com.urbancode.commons.fileutils.digest.DigestUtil;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.xml.DOMUtils;
import com.urbancode.commons.xml.marshall.MarshallingContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class PluginLoader {
    private static final Logger log = Logger.getLogger(PluginLoader.class);
    public static final String PLUGIN_IMPORT_DIRECTORY = "repo";
    public static final String PLUGIN_SERVER_NS = "http://www.urbancode.com/PluginServerXMLSchema_v1";
    public static final String PLUGIN_DESCRIPTOR_FILE = "plugin.xml";
    public static final String PLUGIN_INFO_XML = "info.xml";
    public static final String PLUGIN_INFO_RELEASE_VERSION = "release-version";
    public static final String PLUGIN_SIG_FILE = "plugin.sig";
    public static final String PLUGIN_UPGRADE_FILE = "upgrade.xml";
    public static final String DIGEST_ALG = "SHA-256";
    private final ConnectorPluginCloudDao dao;
    private final IntegrationCloudDao integrationDao;
    private final File pluginDir;
    private final File pluginFile;

    public PluginLoader(ConnectorPluginCloudDao dao, IntegrationCloudDao integrationDao, File pluginDir, File pluginFile) {
        this.dao = dao;
        this.integrationDao = integrationDao;
        this.pluginDir = pluginDir;
        this.pluginFile = pluginFile;
    }

    protected String getPluginHash() throws IOException {
        String result = null;
        try {
            result = DigestUtil.getHexDigest((File)this.pluginFile, (String)DIGEST_ALG);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Algorithm SHA-256 not found", e);
        }
        return result;
    }

    protected void assertSigned(ZipFile pluginZip) throws IOException, GeneralSecurityException {
        PluginSignatureValidator validator = new PluginSignatureValidator(pluginZip);
        if (validator.isSigned()) {
            validator.validateSignature();
        }
    }

    protected void assertValidFileLocation() throws IOException {
    }

    protected InputStream getPluginStream(ZipFile zip) throws IOException {
        ZipEntry entry = zip.getEntry(PLUGIN_DESCRIPTOR_FILE);
        if (entry == null) {
            throw new RuntimeException("The file plugin.xml was not found within the root directory of the zip file.");
        }
        InputStream stream = zip.getInputStream(entry);
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document getPluginInfoDocument(ZipFile zip) throws ParserConfigurationException, SAXException, IOException {
        Document doc = null;
        ZipEntry entry = zip.getEntry(PLUGIN_INFO_XML);
        if (entry == null) {
            throw new RuntimeException("The file info.xml was not found within the root directory of the zip file.");
        }
        if (entry != null) {
            try (InputStream stream = zip.getInputStream(entry);){
                doc = DOMUtils.loadDocument((InputStream)stream);
            }
        }
        return doc;
    }

    protected String getReleaseVersion(Document pluginInfoDoc) {
        Element pluginElement;
        String releaseVersion = null;
        if (pluginInfoDoc != null && (pluginElement = pluginInfoDoc.getDocumentElement()) != null) {
            releaseVersion = DOMUtils.getFirstChildText((Element)pluginElement, (String)PLUGIN_INFO_RELEASE_VERSION);
        }
        return releaseVersion;
    }

    protected AutomationPlugin readPlugin(InputStream xmlStream) throws IOException, ParserConfigurationException, SAXException {
        AutomationPlugin result = null;
        URServerPluginXmlParser parser = new URServerPluginXmlParser();
        result = parser.parse(xmlStream);
        return result;
    }

    protected void setPluginMetadata(Plugin plugin, AutomationPlugin rawPlugin, String hash) {
        plugin.setPluginId(rawPlugin.getId());
        plugin.setName(rawPlugin.getName());
        plugin.setDescription(rawPlugin.getDescription());
        plugin.setPluginHash(hash);
        plugin.setTag(rawPlugin.getTag());
    }

    protected Document getUpgradeDocument(ZipFile zip) throws XPathExpressionException, DOMException, IOException, SchemaValidationException {
        Document result = null;
        ZipEntry entry = zip.getEntry(PLUGIN_UPGRADE_FILE);
        if (entry == null) {
            throw new RuntimeException("The file upgrade.xml was not found within the root directory of the zip file");
        }
        InputStream stream = zip.getInputStream(entry);
        PluginUpgradeValidator validator = new PluginUpgradeValidator();
        result = validator.validateAndTransform(stream);
        return result;
    }

    protected PluginUpgrade readUpgradeData(Document document) throws IOException, XPathExpressionException, SchemaValidationException {
        PluginUpgrade result = null;
        MarshallingContext context = new MarshallingContext();
        Element rootElement = document.getDocumentElement();
        PluginUpgradeMarshallEngine.getInstance().unmarshall(rootElement, context);
        result = (PluginUpgrade)context.get();
        return result;
    }

    protected void verifyValidUpgrade(AutomationPlugin rawPlugin, Plugin latestPlugin, PluginUpgrade upgradeData) throws SchemaValidationException {
        Collection commands = rawPlugin.getCommands();
        HashSet<String> commandNames = new HashSet<String>();
        for (com.urbancode.air.plugin_command.Command command : commands) {
            commandNames.add(command.getName());
        }
        long oldVersion = latestPlugin.getPluginVersion();
        long newVersion = rawPlugin.getVersion();
        List migrations = upgradeData.getMigrationsForVersions(oldVersion, newVersion);
        for (PluginVersionMigration migration : migrations) {
            for (CommandUpgrade commandUpgrade : migration.getCommandUpgradeList()) {
                String oldName = commandUpgrade.getOldName();
                String newName = commandUpgrade.getName();
                if (oldName == null || newName.equals(oldName) || !commandNames.contains(oldName)) continue;
                throw new RuntimeException("Plugin upgrade is attempting an invalid step name change on step name " + oldName + ". Please correct your plugin.xml or upgrade.xml and try again.");
            }
        }
    }

    protected PropDef.PropDefType convertPropType(String typeString) {
        PropDef.PropDefType result = null;
        if (typeString.equalsIgnoreCase("textBox")) {
            result = PropDef.PropDefType.TEXT;
        } else if (typeString.equalsIgnoreCase("textAreaBox")) {
            result = PropDef.PropDefType.TEXTAREA;
        } else if (typeString.equalsIgnoreCase("selectBox")) {
            result = PropDef.PropDefType.SELECT;
        } else if (typeString.equalsIgnoreCase("httpSelectBox")) {
            result = PropDef.PropDefType.HTTP_SELECT;
        } else if (typeString.equalsIgnoreCase("scriptedSelectBox")) {
            result = PropDef.PropDefType.SCRIPTED_SELECT;
        } else if (typeString.equalsIgnoreCase("checkBox")) {
            result = PropDef.PropDefType.CHECKBOX;
        } else if (typeString.equalsIgnoreCase("secureBox")) {
            result = PropDef.PropDefType.SECURE;
        } else if (typeString.equalsIgnoreCase("checkedMultiSelectBox")) {
            result = PropDef.PropDefType.CHECKED_MULTI_SELECT;
        } else if (typeString.equalsIgnoreCase("httpMultiSelectBox")) {
            result = PropDef.PropDefType.HTTP_MULTI_SELECT;
        } else if (typeString.equalsIgnoreCase("httpCheckedMultiSelectBox")) {
            result = PropDef.PropDefType.HTTP_CHECKED_MULTI_SELECT;
        } else if (typeString.equalsIgnoreCase("scriptedCheckedMultiSelectBox")) {
            result = PropDef.PropDefType.SCRIPTED_CHECKED_MULTI_SELECT;
        } else if (typeString.equalsIgnoreCase("scriptedMultiSelectBox")) {
            result = PropDef.PropDefType.SCRIPTED_MULTI_SELECT;
        } else if (typeString.equalsIgnoreCase("button")) {
            result = PropDef.PropDefType.BUTTON;
        } else if (typeString.equalsIgnoreCase("paragraph")) {
            result = PropDef.PropDefType.PARAGRAPH;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LoadType getLoadType(AutomationPlugin rawPlugin, String hash) throws IOException, SAXException, ParserConfigurationException {
        Long pluginVersion;
        String pluginId = rawPlugin.getId();
        Plugin existingVersionMatch = this.getPlugin(pluginId, pluginVersion = Long.valueOf(rawPlugin.getVersion()));
        if (existingVersionMatch == null) {
            Plugin oldVersion = this.getLatestPluginVersion(pluginId);
            if (oldVersion == null) {
                return LoadType.NEW;
            }
            if (oldVersion.getPluginVersion() >= pluginVersion) throw new RuntimeException("Illegal attempt to load an old version of " + pluginId + " (Current loaded version is " + oldVersion.getPluginVersion() + ")");
            return LoadType.API_CHANGE;
        }
        if (existingVersionMatch.getPluginHash().equals(hash)) {
            return LoadType.NO_CHANGE;
        }
        String pluginFileName = Plugin.getPluginFileName(pluginId, pluginVersion);
        File pluginFile = new File(this.pluginDir, pluginFileName);
        if (!pluginFile.exists() && pluginId.contains(".air.")) {
            String oldPluginFileName = pluginFileName.replace(".air.", ".anthill3.");
            pluginFile = new File(this.pluginDir, oldPluginFileName);
        }
        if (!pluginFile.exists()) {
            return LoadType.IMPL_CHANGE;
        }
        ZipFile pluginZip = new ZipFile(pluginFile);
        InputStream xmlStream = this.getPluginStream(pluginZip);
        AutomationPlugin oldRawPlugin = this.readPlugin(xmlStream);
        if (!oldRawPlugin.apiEquals(rawPlugin)) throw new RuntimeException("An API change was detected without a corresponding version change while loading a plugin.");
        return LoadType.IMPL_CHANGE;
    }

    private Plugin upgradePlugin(ZipFile pluginZip, AutomationPlugin rawPlugin, String hash) throws XPathExpressionException, IOException, SchemaValidationException {
        Document upgradeDocument = this.getUpgradeDocument(pluginZip);
        PluginUpgrade upgradeData = this.readUpgradeData(upgradeDocument);
        Plugin latestPlugin = this.getLatestPluginVersion(rawPlugin.getId());
        this.verifyValidUpgrade(rawPlugin, latestPlugin, upgradeData);
        Plugin newPlugin = this.createNewPlugin(rawPlugin, hash);
        newPlugin = this.dao.update((ConnectorPlugin)newPlugin);
        for (Integration integration : this.integrationDao.getAll()) {
            ConnectorPlugin integrationPlugin = integration.getPlugin();
            if (!newPlugin.getPluginId().equals(integrationPlugin.getPluginId()) || newPlugin.getId().equals(integrationPlugin.getId())) continue;
            log.info((Object)("Updating integration '" + integration.getName() + "' to use plugin v" + newPlugin.getPluginVersion()));
            integration.setPlugin((ConnectorPlugin)newPlugin);
            integration = this.integrationDao.update(integration);
        }
        return newPlugin;
    }

    private Plugin createNewPlugin(AutomationPlugin rawPlugin, String hash) throws IOException, XPathExpressionException, SchemaValidationException {
        Plugin plugin = this.createPlugin(rawPlugin);
        this.setPluginMetadata(plugin, rawPlugin, hash);
        for (com.urbancode.air.plugin_command.Command rawCommand : rawPlugin.getCommands()) {
            URCommandExtension commandExtension = (URCommandExtension)rawCommand.getExtension();
            Command command = this.createNewCommand(plugin, rawCommand, commandExtension.isDisplayed());
            plugin.addCommand(command);
            this.addOrUpdateUICommandDefinition(command, rawCommand);
        }
        plugin = this.dao.create((ConnectorPlugin)plugin);
        return plugin;
    }

    private void addOrUpdateUICommandDefinition(Command command, com.urbancode.air.plugin_command.Command rawCommand) {
        int index = 1;
        UICommandDefinition uiCmdDef = new UICommandDefinition(command);
        command.setUICommandDefinition(uiCmdDef);
        PropSheetDef propSheetDef = uiCmdDef.getPropSheetDef();
        List propDefsToDelete = propSheetDef.getPropDefList();
        ArrayList<UIFieldDefinition> fieldList = new ArrayList<UIFieldDefinition>();
        ArrayList<UIFieldDefinition> groupFieldList = new ArrayList<UIFieldDefinition>();
        URCommandExtension commandExtension = (URCommandExtension)rawCommand.getExtension();
        for (URPluginCommandGroupProperty propUIGroup : commandExtension.getGroupProperties()) {
            UIFieldDefinition uiFieldDef = new UIFieldDefinition(uiCmdDef);
            uiFieldDef.setName(propUIGroup.getName());
            uiFieldDef.setDescription(propUIGroup.getDescription());
            uiFieldDef.setType(UIFieldDefinition.UIFieldType.GROUP.toString());
            uiFieldDef.setWidget(propUIGroup.getType().toString());
            uiFieldDef.setTitle(propUIGroup.getTitle());
            if (propUIGroup.getPrerequisistes() != null) {
                uiFieldDef.setPrerequisites(propUIGroup.getPrerequisistes());
            }
            if (propUIGroup.getUnless() != null) {
                uiFieldDef.setUnless(propUIGroup.getUnless());
            }
            uiFieldDef.setOrder(0);
            groupFieldList.add(uiFieldDef);
            uiCmdDef.addUIFieldDefinition(uiFieldDef);
        }
        List props = rawCommand.getPluginProps();
        for (PluginCommandProperty prop : props) {
            Field field;
            HttpPropInfo propInfo;
            URPluginCommandPropertyExtension urProp = (URPluginCommandPropertyExtension)prop.getExtension();
            UIFieldDefinition uiFieldDef = new UIFieldDefinition(uiCmdDef);
            uiFieldDef.setType(UIFieldDefinition.UIFieldType.FIELD.toString());
            uiFieldDef.setOrder(index);
            uiFieldDef.setName(prop.getName());
            uiFieldDef.setDescription(urProp.getDescription());
            PropDef propDef = propSheetDef.getPropDef(prop.getName());
            if (propDef == null) {
                PropDef.PropDefType propType = this.convertPropType(urProp.getType().toString());
                propDef = propSheetDef.createPropDef(propType, prop.getName());
            }
            if (urProp.getPrerequisites() != null) {
                uiFieldDef.setPrerequisites(urProp.getPrerequisites());
            }
            if (urProp.getUnless() != null) {
                uiFieldDef.setUnless(urProp.getUnless());
            }
            if (urProp.getOptions() != null) {
                uiFieldDef.setOptions(urProp.getOptions());
            }
            propDef.setDescription(urProp.getDescription());
            propDef.setDefaultValue(urProp.getDefaultValue());
            propDef.setLabel(urProp.getLabel());
            propDef.setHidden(urProp.isHidden());
            propDef.setRequired(prop.isRequired());
            propDef.removeAllAllowedValues();
            if (prop.getAllowedValues() != null) {
                for (SelectValue value : prop.getAllowedValues()) {
                    propDef.addAllowedValue(value.getValue(), value.getLabel());
                }
            }
            propDefsToDelete.remove(propDef);
            if (propDef.getType().isHttpBased()) {
                propInfo = new HttpPropInfo(propDef, urProp.getHttpPropInfo());
                try {
                    field = propDef.getClass().getDeclaredField("httpPropInfo");
                    field.setAccessible(true);
                    field.set(propDef, propInfo);
                }
                catch (Exception e) {
                    log.error((Object)"Error setting scripted property info on plugin property", (Throwable)e);
                }
            } else if (propDef.getType().isScriptedBased()) {
                propInfo = new ScriptedPropInfo(propDef, urProp.getScriptedPropInfo());
                try {
                    field = propDef.getClass().getDeclaredField("scriptedPropInfo");
                    field.setAccessible(true);
                    field.set(propDef, propInfo);
                }
                catch (Exception e) {
                    log.error((Object)"Error setting scripted property info on plugin property", (Throwable)e);
                }
            }
            uiFieldDef.setPropDef(propDef);
            if (urProp.getParent() != null) {
                for (UIFieldDefinition parent : groupFieldList) {
                    if (!parent.getName().equals(urProp.getParent())) continue;
                    parent.addChild(uiFieldDef);
                    if (parent.getOrder() == 0) {
                        parent.setOrder(index);
                    }
                    uiFieldDef.setParent(parent);
                    uiFieldDef.setUiCommandDefinition(null);
                }
            } else {
                fieldList.add(uiFieldDef);
            }
            uiCmdDef.addUIFieldDefinition(uiFieldDef);
            ++index;
            for (PropDef propDefToDelete : propDefsToDelete) {
                propSheetDef.removePropDef(propDefToDelete);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Plugin loadPlugin() throws Exception {
        Plugin result;
        String hash = this.getPluginHash();
        ZipFile pluginZip = new ZipFile(this.pluginFile);
        try {
            InputStream xmlStream = this.getPluginStream(pluginZip);
            AutomationPlugin rawPlugin = this.readPlugin(xmlStream);
            this.checkPluginType(rawPlugin);
            LoadType loadType = this.getLoadType(rawPlugin, hash);
            this.enforceRequiredServerVersion(rawPlugin);
            String pluginId = rawPlugin.getId();
            long pluginVersion = rawPlugin.getVersion();
            Plugin existingPlugin = this.getPlugin(pluginId, pluginVersion);
            if (!loadType.equals((Object)LoadType.NO_CHANGE)) {
                String targetFileName = Plugin.getPluginFileName(pluginId, pluginVersion);
                File targetFile = new File(this.pluginDir, targetFileName);
                try {
                    FileUtils.copyFile((File)this.pluginFile, (File)targetFile);
                    String loadedHashName = Plugin.getPluginHashName(pluginId, pluginVersion);
                    File finalStepTypeHash = new File(this.pluginDir, loadedHashName);
                    IO.writeTextFile((File)finalStepTypeHash, (String)hash);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to copy staged plugin file (" + this.pluginFile + ") to its final location (" + targetFile + ")", e);
                }
            }
            switch (loadType) {
                case NO_CHANGE: {
                    log.debug((Object)("Newly loaded plugin " + pluginId + " was identical to the existing " + "plugin. No action needed."));
                    result = existingPlugin;
                    break;
                }
                case NEW: {
                    log.debug((Object)("Loading new plugin " + pluginId));
                    result = this.createNewPlugin(rawPlugin, hash);
                    break;
                }
                case API_CHANGE: {
                    log.debug((Object)("Performing upgrade and automated migration of plugin " + pluginId));
                    result = this.upgradePlugin(pluginZip, rawPlugin, hash);
                    break;
                }
                case IMPL_CHANGE: {
                    log.debug((Object)("Updating plugin contents and metadata for an implementation change to " + pluginId + "."));
                    this.setPluginMetadata(existingPlugin, rawPlugin, hash);
                    result = this.dao.update((ConnectorPlugin)existingPlugin);
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid load type: " + (Object)((Object)loadType));
                }
            }
            if (!LoadType.NO_CHANGE.equals((Object)loadType)) {
                Document pluginInfoDoc = this.getPluginInfoDocument(pluginZip);
                String releaseVersion = this.getReleaseVersion(pluginInfoDoc);
                result.setReleaseVersion(releaseVersion);
            }
        }
        finally {
            IO.close((ZipFile)pluginZip);
            if (!FileUtils.deleteFile((File)this.pluginFile)) {
                log.error((Object)("Failed to delete staged plugin file " + this.pluginFile));
            }
        }
        return result;
    }

    protected void enforceRequiredServerVersion(AutomationPlugin rawPlugin) {
    }

    public Plugin getPlugin(String pluginId, Long pluginVersion) {
        return this.dao.getPlugin(pluginId, pluginVersion);
    }

    public Plugin getLatestPluginVersion(String pluginId) {
        return this.dao.getLatestPluginVersion(pluginId);
    }

    public Plugin createPlugin(AutomationPlugin rawPlugin) {
        ConnectorPlugin plugin = null;
        PluginExtension extension = (PluginExtension)rawPlugin.getExtension();
        if (extension.getType() == PluginType.Connector) {
            plugin = new ConnectorPlugin(rawPlugin.getId(), rawPlugin.getVersion());
        }
        return plugin;
    }

    public void checkPluginType(AutomationPlugin rawPlugin) {
        if (!((PluginExtension)rawPlugin.getExtension()).getType().equals((Object)PluginType.Connector)) {
            throw new RuntimeException("Type of plugin " + ((PluginExtension)rawPlugin.getExtension()).getType().toString() + " not expected ");
        }
    }

    public Command createNewCommand(Plugin plugin, com.urbancode.air.plugin_command.Command newCommand, boolean displayed) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Creating Command '" + newCommand.getName() + "'."));
        }
        Command command = new Command(plugin);
        plugin.addCommand(command);
        command.setDescription(newCommand.getDescription());
        command.setName(newCommand.getName());
        command.setDisplayed(displayed);
        PropSheetDef propGrp = command.getPropSheetDef();
        for (PluginCommandProperty commandProp : newCommand.getPluginProps()) {
            this.createPropDef(propGrp, commandProp);
        }
        return command;
    }

    private PropDef createPropDef(PropSheetDef propGroup, PluginCommandProperty newProperty) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Creating Property '" + newProperty.getName() + "'."));
        }
        PropDef result = new PropDef(propGroup, newProperty.getName());
        URPluginCommandPropertyExtension extension = (URPluginCommandPropertyExtension)newProperty.getExtension();
        propGroup.addPropDef(result);
        result.setDefaultValue(extension.getDefaultValue());
        result.setLabel(extension.getLabel());
        result.setRequired(newProperty.isRequired());
        result.setHidden(extension.isHidden());
        result.setDescription(extension.getDescription());
        PropDef.PropDefType convertedType = this.convertPropType(extension.getType().toString());
        result.setType(convertedType);
        if ((convertedType == PropDef.PropDefType.SELECT || convertedType == PropDef.PropDefType.MULTI_SELECT) && newProperty.getAllowedValues() != null) {
            for (SelectValue newVal : newProperty.getAllowedValues()) {
                result.addAllowedValue(newVal.getValue(), newVal.getLabel());
            }
        }
        return result;
    }

    public static enum LoadType {
        NEW,
        NO_CHANGE,
        API_CHANGE,
        IMPL_CHANGE;

    }
}

