/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.plugin.loader;

import com.ibm.cloud.urbancode.sync.plugin.Plugin;
import com.urbancode.air.plugin_command.runtime.Fetcher;
import com.urbancode.air.plugin_command.runtime.FetcherException;
import com.urbancode.commons.util.IO;
import java.io.File;
import java.io.IOException;

public class PluginFetcher
extends Fetcher {
    private final Plugin plugin;

    public PluginFetcher(File storageDir, Plugin plugin) {
        super(storageDir);
        this.plugin = plugin;
    }

    protected File fetch(String pluginId, Long version, String hash) throws FetcherException {
        File result = new File(this.storageDir, pluginId + "_" + version + "_" + hash);
        if (!result.isDirectory()) {
            File pluginFile = new File(this.storageDir, pluginId + "_" + version + ".zip");
            if (!pluginFile.isFile()) {
                throw new FetcherException("Could not find Plugin: " + pluginFile.getPath());
            }
            if (!pluginFile.canRead()) {
                throw new FetcherException("Could not read Plugin: " + pluginFile.getPath());
            }
            try {
                IO.unzipSync((File)pluginFile, (File)result);
            }
            catch (IOException e) {
                throw new FetcherException("Failed to extract the plugin zip: " + pluginFile.getPath(), (Throwable)e);
            }
        }
        return result;
    }

    protected String getHash(String id, Long version) throws FetcherException {
        return this.plugin.getPluginHash();
    }

    protected void cleanup(String pluginId, Long version, String hash) throws FetcherException {
    }
}

