/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.plugin;

import com.ibm.cloud.urbancode.sync.models.Described;
import com.ibm.cloud.urbancode.sync.plugin.Command;
import com.ibm.cloud.urbancode.sync.plugin.UIFieldDefinition;
import com.urbancode.air.property.prop_sheet_def.PropSheetDef;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;

public class UICommandDefinition
extends Described
implements Comparable<UICommandDefinition> {
    private String subTag = null;
    @ManyToOne
    private PropSheetDef propSheetDef = new PropSheetDef();
    @OneToOne
    private Command command;
    @OneToMany(mappedBy="uiCommandDefinition")
    private SortedSet<UIFieldDefinition> fields = new TreeSet<UIFieldDefinition>();

    public UICommandDefinition() {
    }

    public UICommandDefinition(Command command) {
        this.name = command.getName();
        this.command = command;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public PropSheetDef getPropSheetDef() {
        return this.propSheetDef;
    }

    public void setSubTag(String subTag) {
        this.subTag = subTag;
    }

    public String getSubTag() {
        return this.subTag;
    }

    public void addUIFieldDefinition(UIFieldDefinition field) {
        if (!this.fields.contains(field)) {
            this.fields.add(field);
        }
    }

    public SortedSet<UIFieldDefinition> getFields() {
        return Collections.unmodifiableSortedSet(this.fields);
    }

    public UIFieldDefinition getFieldByName(String name) {
        for (UIFieldDefinition uiFieldDef : this.getFields()) {
            if (!name.equals(uiFieldDef.getName())) continue;
            return uiFieldDef;
        }
        return null;
    }

    @Override
    public int compareTo(UICommandDefinition o) {
        return super.compareTo(o);
    }
}

