/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.plugin;

import com.ibm.cloud.urbancode.sync.plugin.Plugin;
import com.ibm.cloud.urbancode.sync.plugin.loader.PluginFetcher;
import com.urbancode.air.plugin_command.runtime.AutomationPluginRuntime;
import com.urbancode.air.plugin_command.runtime.Fetcher;
import com.urbancode.air.plugin_command.runtime.ShellHelper;
import com.urbancode.air.plugin_command.runtime.StepExecutionInfo;
import com.urbancode.air.plugin_command.xml.AutomationPluginRuntimeMarshallEngine;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.xml.marshall.MarshallingEngine;
import com.urbancode.shell.impersonation.ImpersonationToken;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.apache.log4j.Logger;

public class PluginRunner {
    private static Logger log = Logger.getLogger(PluginRunner.class);
    public static String PROP_PLUGIN_ID = "plugin_id";
    public static String PROP_PLUGIN_VER = "plugin_ver";
    public static String PROP_COMMAND_NAME = "step_name";
    public static String PROP_WORK_DIR_NAME = "work_dir_name";
    public static String PROP_PROPS = "props";
    public static String PROP_ENV_PROPS = "env_props";
    public static String PROP_SECURE_VALUES = "secure_values";
    public static String PROP_LOGS_URL = "logs_url";
    public static String PROP_IMPERSONATION_TOKEN = "imp_token";
    public static String PROP_AUTH_TOKEN = "auth_token";
    public static String LOG_PROP = "log_prop";
    public static String ERR_PROP = "err_prop";
    public static String EXIT_CODE_PROP = "exit_code_prop";
    public static String POST_PROCESS_BODY = "post_process_body";
    public static String PROP_FIN = "FIN";
    public static String STDOUT_FILE = "stdout_file";
    public static String OUT_FILE_PROP = "out_file";
    public static String INPUT_FILE_PROP = "input_file";
    public static String ERR_FILE_PROP = "err_file";
    public static String LOG_URL_PROP = "log_url_prop";
    public static String LOG_SEMAPHORE_PROP = "log_semaphore_prop";
    public static String RESULT_CWD = "cwd";
    public static String RESULT_PROPS = "props_content";
    public static String RESULT_STD_OUT = "out_content";
    public static String RESULT_STD_ERR = "err_content";
    private final Plugin plugin;
    private final String commandName;
    private final File pluginStorageDir;
    private final String workDirName;
    private final String postProcBody;
    private final ImpersonationToken impersonationToken;
    private final Map<String, String> pluginProps;
    private final Map<String, String> envProps;
    private final Set<String> secureValues;

    public PluginRunner(Plugin plugin, String commandName, File pluginStorageDir, String workDirName, String postProcBody, ImpersonationToken impersonationToken, Map<String, String> pluginProps, Map<String, String> envProps, Set<String> secureValues) {
        this.plugin = plugin;
        this.commandName = commandName;
        this.pluginStorageDir = pluginStorageDir;
        this.workDirName = workDirName;
        this.postProcBody = postProcBody;
        this.impersonationToken = impersonationToken;
        this.envProps = envProps;
        this.pluginProps = pluginProps;
        this.secureValues = secureValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> executePluginStep() {
        HashMap<String, String> result;
        block16: {
            result = new HashMap<String, String>();
            Properties outputProps = new Properties();
            StepExecutionInfo info = new StepExecutionInfo(UUID.randomUUID());
            try {
                PluginFetcher fetcherLocal = new PluginFetcher(this.pluginStorageDir, this.plugin);
                AutomationPluginRuntimeMarshallEngine engine = AutomationPluginRuntimeMarshallEngine.getInstance();
                AutomationPluginRuntime runtime = new AutomationPluginRuntime((Fetcher)fetcherLocal, (MarshallingEngine)engine);
                runtime.setDisplayDetailsInOutput(true);
                File workingDir = new File(this.workDirName);
                log.debug((Object)("Working Directory: " + workingDir.getAbsolutePath()));
                if (!workingDir.exists()) {
                    workingDir.mkdirs();
                }
                if (this.secureValues != null) {
                    log.trace((Object)("Received SECURE VALUES: " + this.secureValues.size() + " entries."));
                }
                File tempDir = null;
                File tempOutFile = null;
                File tempErrFile = null;
                File tempInputPropsFile = null;
                File tempOutputPropsFile = null;
                File tempEnvPropsFile = null;
                FileOutputStream tempInputPropsFileStream = null;
                FileOutputStream tempEnvPropsFileStream = null;
                try {
                    log.debug((Object)"Executing plugin step...");
                    tempDir = File.createTempFile("cloud-sync-command-", "");
                    log.debug((Object)("Temp Directory: " + tempDir.getAbsolutePath()));
                    tempDir.delete();
                    tempDir.mkdirs();
                    tempOutFile = new File(tempDir, "stdOut.txt");
                    tempErrFile = new File(tempDir, "log.txt");
                    tempInputPropsFile = new File(tempDir, "input.props");
                    tempOutputPropsFile = new File(tempDir, "output.props");
                    tempEnvPropsFile = new File(tempDir, "env.props");
                    ShellHelper helper = new ShellHelper(Charset.defaultCharset());
                    ShellHelper.setInstance((ShellHelper)helper);
                    ShellHelper.getInstance().chmodDirectory(tempDir, "wr");
                    try {
                        Properties tempInputProps = new Properties();
                        for (String key : this.pluginProps.keySet()) {
                            if (this.pluginProps.get(key) == null) continue;
                            tempInputProps.put(key, this.pluginProps.get(key));
                        }
                        tempInputPropsFileStream = new FileOutputStream(tempInputPropsFile);
                        tempInputProps.store(tempInputPropsFileStream, "");
                    }
                    catch (Throwable throwable) {
                        IO.close(tempInputPropsFileStream);
                        throw throwable;
                    }
                    IO.close((OutputStream)tempInputPropsFileStream);
                    try {
                        Properties tempEnvProps = new Properties();
                        tempEnvProps.putAll(this.envProps);
                        tempEnvPropsFileStream = new FileOutputStream(tempEnvPropsFile);
                        tempEnvProps.store(tempEnvPropsFileStream, "");
                    }
                    catch (Throwable throwable) {
                        IO.close(tempEnvPropsFileStream);
                        throw throwable;
                    }
                    IO.close((OutputStream)tempEnvPropsFileStream);
                    result.put(INPUT_FILE_PROP, tempInputPropsFile.getAbsolutePath());
                    result.put(OUT_FILE_PROP, tempOutputPropsFile.getAbsolutePath());
                    result.put(STDOUT_FILE, tempOutFile.getAbsolutePath());
                    result.put(ERR_FILE_PROP, tempErrFile.getAbsolutePath());
                    runtime.setDisplayDetailsInOutput(false);
                    runtime.executeCommand(this.plugin.getPluginId(), this.plugin.getPluginVersion(), this.commandName, tempInputPropsFile, tempEnvPropsFile, tempOutputPropsFile, workingDir, tempOutFile, tempErrFile, this.secureValues, this.impersonationToken, info, this.postProcBody);
                    log.debug((Object)"PluginRuntimeServer.handleMessage() executed plugin step");
                }
                catch (Exception e) {
                    log.error((Object)"Exception running plugin command", (Throwable)e);
                    outputProps.put("Exception", e.getMessage());
                    PrintWriter logWriter = null;
                    try {
                        if (!tempErrFile.exists()) {
                            tempErrFile.createNewFile();
                        }
                        logWriter = new PrintWriter(tempErrFile);
                        e.printStackTrace(logWriter);
                    }
                    catch (Exception ex) {
                        try {
                            log.error((Object)"Error writing plugin runtime exception to log file!", (Throwable)ex);
                        }
                        catch (Throwable throwable) {
                            IO.close(logWriter);
                            throw throwable;
                        }
                        IO.close((Writer)logWriter);
                        break block16;
                    }
                    IO.close((Writer)logWriter);
                }
            }
            catch (Exception ex) {
                log.error((Object)"Exception attempting to run plugin command", (Throwable)ex);
            }
        }
        return result;
    }

    Map<String, String> extractResult(Map<String, String> outPut) {
        HashMap<String, String> result = new HashMap<String, String>();
        File propsFile = new File(outPut.get(OUT_FILE_PROP));
        File errFile = new File(outPut.get(ERR_FILE_PROP));
        File outFile = new File(outPut.get(STDOUT_FILE));
        try {
            result.put(RESULT_CWD, propsFile.getParentFile().getAbsolutePath());
            result.put(RESULT_STD_ERR, IO.readTextFile((File)errFile));
            result.put(RESULT_STD_OUT, IO.readTextFile((File)outFile));
            result.put(RESULT_PROPS, IO.readTextFile((File)propsFile));
        }
        catch (Exception e) {
            log.error((Object)"Could not parse command results", (Throwable)e);
        }
        return result;
    }
}

