/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.plugin;

import com.ibm.cloud.urbancode.sync.SyncApplication;
import com.ibm.cloud.urbancode.sync.persistence.cloud.ConnectorPluginCloudDao;
import com.ibm.cloud.urbancode.sync.persistence.cloud.IntegrationCloudDao;
import com.ibm.cloud.urbancode.sync.plugin.Plugin;
import com.ibm.cloud.urbancode.sync.plugin.loader.PluginLoader;
import com.urbancode.commons.fileutils.FileExtensionFilter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Component;

@Component(value="PluginInitialization")
public class PluginInitialization {
    public static final Logger log = LoggerFactory.getLogger(PluginInitialization.class);
    private final ConnectorPluginCloudDao dao;
    private final IntegrationCloudDao integrationDao;
    private final File pluginDir;

    @Autowired
    public PluginInitialization(ConnectorPluginCloudDao dao, IntegrationCloudDao integrationDao, SyncApplication app) {
        File pluginRepoDir;
        this.dao = dao;
        this.integrationDao = integrationDao;
        this.pluginDir = new File(app.getStorageDir(), "plugins");
        if (!this.pluginDir.exists()) {
            this.pluginDir.mkdirs();
        }
        if (!(pluginRepoDir = this.getPluginRepoDir()).exists()) {
            pluginRepoDir.mkdirs();
        }
    }

    public File getPluginDir() {
        return this.pluginDir;
    }

    public File getPluginRepoDir() {
        return new File(this.pluginDir, "repo");
    }

    public File getPluginStageDir() {
        return new File(this.pluginDir, "stage");
    }

    public Runnable getPluginInitializationRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                log.info("Initializing plugins");
                List plugins = PluginInitialization.this.dao.getAll();
                if (plugins != null) {
                    for (Plugin plugin : plugins) {
                        log.info("Existing plugin: " + plugin.getName() + " v" + plugin.getPluginVersion() + " - " + plugin.getId());
                    }
                }
                File pluginRepoDir = PluginInitialization.this.getPluginRepoDir();
                File pluginStageDir = PluginInitialization.this.getPluginStageDir();
                log.info("Checking " + pluginStageDir.getAbsolutePath() + " for plugins...");
                if (pluginStageDir.exists()) {
                    File[] pluginArchives = pluginStageDir.listFiles((FilenameFilter)new FileExtensionFilter("zip"));
                    if (pluginArchives.length > 0) {
                        log.info("Loading " + pluginArchives.length + " staged plugin" + (pluginArchives.length == 1 ? "" : "s") + "...");
                    }
                    for (File stagePluginFile : pluginArchives) {
                        try {
                            log.info("Loading " + stagePluginFile.getName() + "...");
                            new PluginLoader(PluginInitialization.this.dao, PluginInitialization.this.integrationDao, pluginRepoDir, stagePluginFile).loadPlugin();
                        }
                        catch (Exception e) {
                            log.error("Error loading plugin " + stagePluginFile.getAbsolutePath(), (Throwable)e);
                        }
                    }
                } else {
                    pluginStageDir.mkdirs();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void postConstruct() {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        Resource[] resources = null;
        try {
            resources = resolver.getResources("classpath:plugins/*.zip");
        }
        catch (Exception e) {
            log.error("Error checking for built-in integration plugins", (Throwable)e);
        }
        if (resources != null) {
            for (Resource pluginResource : resources) {
                String pluginFilename = pluginResource.getFilename();
                File pluginRepoFile = new File(this.getPluginRepoDir(), pluginFilename);
                if (pluginRepoFile.exists()) {
                    log.info("Skipping built-in integration plugin: " + pluginResource.getFilename());
                    continue;
                }
                File stageDir = this.getPluginStageDir();
                stageDir.mkdirs();
                File pluginFile = new File(stageDir, pluginFilename);
                InputStream inputStream = null;
                FileOutputStream outputStream = null;
                try {
                    inputStream = pluginResource.getInputStream();
                    outputStream = new FileOutputStream(pluginFile);
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                    log.info("Staged built-in integration plugin: " + pluginResource.getFilename());
                }
                catch (Exception e) {
                    try {
                        log.error("Error staging built-in integration plugin: " + pluginResource.getFilename(), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly((InputStream)inputStream);
                        IOUtils.closeQuietly(outputStream);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)inputStream);
                    IOUtils.closeQuietly((OutputStream)outputStream);
                    continue;
                }
                IOUtils.closeQuietly((InputStream)inputStream);
                IOUtils.closeQuietly((OutputStream)outputStream);
            }
        }
    }
}

