/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.plugin;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ibm.cloud.urbancode.sync.GroovyInstallation;
import com.ibm.cloud.urbancode.sync.SyncApplicationProperties;
import com.ibm.cloud.urbancode.sync.models.Integration;
import com.ibm.cloud.urbancode.sync.plugin.Command;
import com.ibm.cloud.urbancode.sync.plugin.Plugin;
import com.ibm.cloud.urbancode.sync.plugin.PluginInitialization;
import com.ibm.cloud.urbancode.sync.plugin.PluginRunner;
import com.ibm.cloud.urbancode.sync.plugin.UICommandDefinition;
import com.ibm.cloud.urbancode.sync.plugin.UIFieldDefinition;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import com.urbancode.air.property.prop_def.PropDef;
import com.urbancode.air.property.prop_def.PropDefAllowedValue;
import com.urbancode.air.property.prop_def.http.HttpPropInfo;
import com.urbancode.air.property.prop_def.scripted.ScriptedPropInfo;
import com.urbancode.air.property.prop_value.PropValue;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.StringUtil;
import com.urbancode.commons.util.crypto.CryptStringUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class PluginHelper {
    private static final Logger log = Logger.getLogger(PluginHelper.class);
    public static String SSL_TRUSTSTORE = "SSL_TRUSTSTORE";
    public static String SSL_TRUSTSTORE_PASSWORD = "SSL_TRUSTSTORE_PASSWORD";
    private final PluginInitialization pluginInitialization;
    private final GroovyInstallation groovy;
    private final Cache<String, String> cache;
    private final String syncUrl;
    private final String syncEnv;
    private final Map<UUID, Boolean> runningIntegrationsMap;

    @Autowired
    public PluginHelper(PluginInitialization pluginInitialization, GroovyInstallation groovy, Environment environment, @Value(value="${server.port}") String serverPort) {
        this.pluginInitialization = pluginInitialization;
        this.groovy = groovy;
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
        String tempSyncUrl = "https://localhost:" + serverPort;
        try {
            tempSyncUrl = "https://" + InetAddress.getLocalHost().getHostName() + ":" + serverPort;
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        this.syncUrl = tempSyncUrl;
        String[] profiles = environment.getActiveProfiles();
        this.syncEnv = profiles == null || profiles.length == 0 ? "prod" : profiles[0];
        this.runningIntegrationsMap = new ConcurrentHashMap<UUID, Boolean>();
    }

    public JsonArray resolveExternalPropertiesValues(Integration provider, String propDefName, Plugin plugin, String commandName, String labelFilter, String range, HttpServletResponse response, UriInfo allQueryParams, HttpHeaders allHeaderParams) throws Exception {
        UICommandDefinition uiCommandDef;
        UIFieldDefinition field;
        MultivaluedMapImpl allTempParams = new MultivaluedMapImpl(allQueryParams.getQueryParameters());
        JsonArray result = new JsonArray();
        Command command = null;
        HttpPropInfo httpPropInfo = null;
        ScriptedPropInfo scriptedPropInfo = null;
        if (provider != null && provider.getPropSheet() != null) {
            for (PropDef propDef : provider.getPropSheetDef().getPropDefList()) {
                if (!propDef.isSecure() || !"****".equals(allTempParams.getFirst((Object)propDef.getName()))) continue;
                allTempParams.remove((Object)propDef.getName());
                allTempParams.add((Object)propDef.getName(), (Object)provider.getPropSheet().getPropValue(propDef.getName()));
            }
        }
        if (plugin != null && (command = plugin.getCommandByName(commandName)) != null && command.getUICommandDefinition() != null && (field = (uiCommandDef = command.getUICommandDefinition()).getFieldByName(propDefName)) != null) {
            if (field.getPropDef().getHttpPropInfo() != null) {
                httpPropInfo = field.getPropDef().getHttpPropInfo();
            } else if (field.getPropDef().getScriptedPropInfo() != null) {
                scriptedPropInfo = field.getPropDef().getScriptedPropInfo();
            }
        }
        if (httpPropInfo != null) {
            // empty if block
        }
        if (scriptedPropInfo != null) {
            String cacheKey = null;
            cacheKey = provider == null ? plugin.getId().toString() : provider.getId().toString();
            ScriptedPropInfo infoWithResolvedProperties = new ScriptedPropInfo();
            if (scriptedPropInfo.getScriptedDataSourceType() == ScriptedPropInfo.ScriptedDataSourceType.COMMAND) {
                this.resolvedScriptedPropInfo(infoWithResolvedProperties, scriptedPropInfo, provider, (MultivaluedMap<String, String>)allTempParams);
                String output = null;
                output = this.attemptRestoreFromCache(scriptedPropInfo, cacheKey);
                if (output == null) {
                    Map<String, String> outProps = this.resolvePropertiesFromScript(plugin, command, infoWithResolvedProperties.getSource(), (MultivaluedMap<String, String>)allTempParams, provider);
                    if (outProps.containsKey("outputProperty")) {
                        output = outProps.get("outputProperty");
                    } else {
                        output = outProps.get(PluginRunner.RESULT_STD_OUT);
                        output = output.replace("<br />", System.getProperty("line.separator"));
                    }
                    String status = outProps.get("executionStatus");
                    if (!"Success".equalsIgnoreCase(status)) {
                        log.error((Object)("Error getting value for property '" + propDefName + "' using plugin '" + plugin.getName() + "' with command '" + commandName + "': " + output));
                    }
                    this.cache(scriptedPropInfo, cacheKey, output);
                }
                List allowedValues = infoWithResolvedProperties.getAllowedValues(output);
                this.filterResolvedValues(allowedValues, labelFilter, range, response);
                result = this.getAllowedValuesJsonArray(allowedValues);
            }
        }
        return result;
    }

    private JsonArray getAllowedValuesJsonArray(List<PropDefAllowedValue> allowedValues) {
        JsonArray allowedValueJsonArray = new JsonArray();
        for (PropDefAllowedValue allowedValue : allowedValues) {
            allowedValueJsonArray.add((JsonElement)this.getAllowedValueJson(allowedValue));
        }
        return allowedValueJsonArray;
    }

    private JsonObject getAllowedValueJson(PropDefAllowedValue allowedValue) {
        JsonObject allowedValueJsonObject = new JsonObject();
        allowedValueJsonObject.addProperty("label", allowedValue.getLabel());
        allowedValueJsonObject.addProperty("value", allowedValue.getValue());
        return allowedValueJsonObject;
    }

    private void filterResolvedValues(List<PropDefAllowedValue> allowedValues, String labelFilter, String range, HttpServletResponse response) {
        Pattern pattern;
        Matcher matcher;
        if (!StringUtil.isEmpty((String)labelFilter)) {
            String namePatternRegex = labelFilter.replace("?", ".?").replace("*", ".*").replace("\\", "\\\\?");
            ListIterator<PropDefAllowedValue> it = allowedValues.listIterator();
            while (it.hasNext()) {
                PropDefAllowedValue allowedValue = it.next();
                if (allowedValue.getLabel().matches(namePatternRegex)) continue;
                it.remove();
            }
        }
        if (!StringUtil.isEmpty((String)range) && (matcher = (pattern = Pattern.compile("items=(\\d*)-(\\d*)")).matcher(range)).find()) {
            int startIndex = Integer.valueOf(matcher.group(1));
            int endIndex = Integer.valueOf(matcher.group(2)) + 1;
            int total = allowedValues.size();
            if (endIndex > allowedValues.size()) {
                endIndex = allowedValues.size();
            }
            if (startIndex >= endIndex) {
                allowedValues.clear();
            } else {
                ArrayList<PropDefAllowedValue> sublist = new ArrayList<PropDefAllowedValue>(allowedValues.subList(startIndex, endIndex));
                allowedValues.retainAll(sublist);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(startIndex).append('-').append(endIndex - 1).append('/').append(total);
            response.addHeader("Content-Range", sb.toString());
        }
    }

    public ScriptedPropInfo resolvedScriptedPropInfo(ScriptedPropInfo infoWithResolvedProperties, ScriptedPropInfo info, Integration provider, MultivaluedMap<String, String> allTempParams) throws Exception {
        infoWithResolvedProperties.setArguments(this.resolveProperties(provider, allTempParams, info.getArguments()));
        infoWithResolvedProperties.setDataSourceType(this.resolveProperties(provider, allTempParams, info.getDataSourceType()));
        infoWithResolvedProperties.setBasePath(this.resolveProperties(provider, allTempParams, info.getBasePath()));
        infoWithResolvedProperties.setValuePath(this.resolveProperties(provider, allTempParams, info.getValuePath()));
        infoWithResolvedProperties.setLabelPath(this.resolveProperties(provider, allTempParams, info.getLabelPath()));
        infoWithResolvedProperties.setFormatName(this.resolveProperties(provider, allTempParams, info.getFormatName()));
        infoWithResolvedProperties.setSource(this.resolveProperties(provider, allTempParams, info.getSource()));
        return infoWithResolvedProperties;
    }

    private String attemptRestoreFromCache(ScriptedPropInfo info, String key) {
        String result = null;
        if (this.cache != null) {
            result = (String)this.cache.getIfPresent((Object)this.getScriptedPropCacheKey(info, key));
        }
        return result;
    }

    private void cache(ScriptedPropInfo info, String key, String data) {
        if (this.cache != null) {
            this.cache.put((Object)this.getScriptedPropCacheKey(info, key), (Object)data);
        }
    }

    public Map<String, String> resolvePropertiesFromScript(Plugin plugin, Command command, String source, MultivaluedMap<String, String> allTempParams, Integration integration) throws Exception {
        HashMap<String, String> pluginProps = new HashMap<String, String>();
        for (UIFieldDefinition field : command.getUICommandDefinition().getFields()) {
            if (allTempParams == null || !allTempParams.containsKey((Object)field.getName())) continue;
            pluginProps.put(field.getName(), (String)((List)allTempParams.get((Object)field.getName())).get(0));
        }
        return this.executeStep(plugin, command, source, pluginProps, integration, true);
    }

    String getScriptedPropCacheKey(ScriptedPropInfo info, String key) {
        StringBuilder sb = new StringBuilder();
        sb.append(info.getClass().getSimpleName()).append("[");
        sb.append(info.getSource() + info.getFormatName()).append("@").append(key);
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> executeStep(Plugin plugin, Command command, String source, Map<String, String> extraParameters, Integration integration, boolean softFailure) throws Exception {
        Map<String, String> result;
        block24: {
            result = null;
            ArrayList<String> executionLogs = new ArrayList<String>();
            try {
                HashMap<String, String> pluginProps = new HashMap<String, String>();
                if (extraParameters != null) {
                    pluginProps.putAll(extraParameters);
                }
                this.addIntegrationProps(integration, pluginProps);
                this.addSyncProperties(pluginProps);
                for (UIFieldDefinition field : command.getUICommandDefinition().getFields()) {
                    if (!field.getType().equals(UIFieldDefinition.UIFieldType.GROUP.toString())) continue;
                    JsonArray mappingValues = this.getMappingBundle(field, integration);
                    pluginProps.put(field.getName(), mappingValues.toString());
                }
                HashMap<String, String> envProps = new HashMap<String, String>();
                if (StringUtils.isNotBlank((String)System.getProperty("JAVA_HOME"))) {
                    envProps.put("JAVA_HOME", System.getProperty("JAVA_HOME"));
                }
                if (this.groovy != null && StringUtils.isNotBlank((String)this.groovy.getGroovyHomePath())) {
                    envProps.put("GROOVY_HOME", this.groovy.getGroovyHomePath());
                }
                if (StringUtils.isNotBlank((String)System.getProperty("javax.net.ssl.trustStore")) && StringUtils.isNotBlank((String)System.getProperty("javax.net.ssl.trustStorePassword"))) {
                    envProps.put(SSL_TRUSTSTORE, System.getProperty("javax.net.ssl.trustStore"));
                    envProps.put(SSL_TRUSTSTORE_PASSWORD, System.getProperty("javax.net.ssl.trustStorePassword"));
                }
                String commandName = command.getName();
                if (source != null) {
                    commandName = source;
                }
                PluginRunner runner = new PluginRunner(plugin, commandName, this.pluginInitialization.getPluginRepoDir(), System.getProperty("java.io.tmpdir"), null, null, pluginProps, envProps, null);
                this.addLog(Integration.LogType.INFO.toString(), "----" + command.getName() + "----", integration);
                Map<String, String> outPut = runner.executePluginStep();
                result = runner.extractResult(outPut);
                ByteArrayInputStream input = new ByteArrayInputStream(result.get(PluginRunner.RESULT_PROPS).getBytes());
                Properties outPutProps = new Properties();
                outPutProps.load(input);
                String status = outPutProps.getProperty("Status");
                for (String key : outPutProps.stringPropertyNames()) {
                    if (key.equals("exitCode") || key.equals("LOI") || key.equals("Status")) continue;
                    String value = outPutProps.getProperty(key);
                    pluginProps.put(key, value);
                    this.addLog(executionLogs, Integration.LogType.TRACE.toString(), "OutPutProps: " + key + "=" + value);
                }
                if (status != null && status.equalsIgnoreCase("Success")) {
                    this.addLog(executionLogs, Integration.LogType.INFO.toString(), result.get(PluginRunner.RESULT_STD_OUT));
                } else if (status != null && !status.equalsIgnoreCase("Success")) {
                    if (result.get(PluginRunner.RESULT_STD_ERR) != null) {
                        this.addLog(executionLogs, Integration.LogType.ERROR.toString(), result.get(PluginRunner.RESULT_STD_OUT));
                        this.addLog(Integration.LogType.ERROR.toString(), result.get(PluginRunner.RESULT_STD_ERR), integration);
                        if (!softFailure) {
                            throw new RuntimeException(result.get(PluginRunner.RESULT_STD_OUT) + " " + result.get(PluginRunner.RESULT_STD_ERR));
                        }
                    } else if (!softFailure) {
                        throw new RuntimeException("Could not establish connection");
                    }
                }
                this.addLog(Integration.LogType.INFO.toString(), result.get(PluginRunner.RESULT_STD_OUT), integration);
                if (outPutProps.containsKey("Output")) {
                    result.put("executionOutput", outPutProps.getProperty("Output"));
                    result.put("outputProperty", outPutProps.getProperty("Output").toString());
                }
                result.put("executionLogs", ((Object)executionLogs).toString());
                result.put("executionStatus", status);
                ((InputStream)input).close();
                if (result == null || result.get(PluginRunner.RESULT_CWD) == null) break block24;
            }
            catch (Throwable throwable) {
                if (result != null && result.get(PluginRunner.RESULT_CWD) != null) {
                    try {
                        String userHome = new File(System.getProperty("user.home")).getAbsolutePath();
                        File tempDirectory = new File((String)result.get(PluginRunner.RESULT_CWD));
                        if (tempDirectory.getParentFile() != null && !tempDirectory.getAbsolutePath().equals(userHome)) {
                            IO.delete((File)tempDirectory);
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)"Could not delete command transient files directory: ", (Throwable)e);
                    }
                }
                throw throwable;
            }
            try {
                String userHome = new File(System.getProperty("user.home")).getAbsolutePath();
                File tempDirectory = new File(result.get(PluginRunner.RESULT_CWD));
                if (tempDirectory.getParentFile() != null && !tempDirectory.getAbsolutePath().equals(userHome)) {
                    IO.delete((File)tempDirectory);
                }
            }
            catch (Exception e) {
                log.error((Object)"Could not delete command transient files directory: ", (Throwable)e);
            }
        }
        return result;
    }

    void addSyncProperties(Map<String, String> pluginProps) {
        Properties appProps = SyncApplicationProperties.getProperties();
        pluginProps.put("sync.id", appProps.getProperty("sync.id"));
        pluginProps.put("sync.token", appProps.getProperty("sync.token"));
        pluginProps.put("sync.environment", this.syncEnv);
        pluginProps.put("sync.url", this.syncUrl);
    }

    void addIntegrationProps(Integration integration, Map<String, String> pluginProps) {
        if (integration != null) {
            pluginProps.put("releaseIntegrationProvider", integration.getId().toString());
            if (integration.getPropSheet() != null) {
                for (PropValue prop : integration.getPropSheet().getPropValueList()) {
                    if (pluginProps.containsKey(prop.getName())) continue;
                    pluginProps.put(prop.getName(), prop.getValue());
                }
            }
        }
    }

    private JsonArray getMappingBundle(UIFieldDefinition field, Integration integration) throws Exception {
        JsonArray mappingValues = new JsonArray();
        for (PropValue prop : integration.getPropSheet().getPropValueList()) {
            if (!prop.getName().startsWith(field.getName() + ":")) continue;
            JsonObject mappingValue = new JsonObject();
            String idMaster = prop.getName().substring(prop.getName().indexOf(":") + 1, prop.getName().length());
            mappingValue.addProperty(field.getChildren().first().getName(), idMaster);
            mappingValue.addProperty(field.getChildren().last().getName(), prop.getValue());
            mappingValues.add((JsonElement)mappingValue);
        }
        return mappingValues;
    }

    public void addLog(String className, String trace, Integration integration) {
        if (integration != null) {
            integration.executionReport.add("{\"className\": \"" + className + "\", \"text\": \"" + this.sanitizeLog(trace) + "\"}");
        }
        log.debug((Object)trace);
    }

    public void addLog(List<String> logs, String className, String trace) {
        logs.add("{\"className\": \"" + className + "\", \"text\": \"" + this.sanitizeLog(trace) + "\"}");
        log.debug((Object)trace);
    }

    public String sanitizeLog(String log) {
        log = log.replace("\"", "");
        log = log.replace("\t", "");
        log = log.replace("\\", "/");
        return log;
    }

    public String resolveProperties(Integration integration, MultivaluedMap<String, String> allTempParams, String value) {
        return this.resolveProperties(integration, allTempParams, value, false);
    }

    public String resolveProperties(Integration integration, MultivaluedMap<String, String> allTempParams, String value, boolean isEncryptedValue) {
        if (value != null) {
            if (isEncryptedValue) {
                try {
                    value = CryptStringUtil.decrypt((String)value);
                }
                catch (GeneralSecurityException e) {
                    log.error((Object)"Could not decrypt secured value", (Throwable)e);
                }
            }
            if (allTempParams != null && allTempParams.size() > 0) {
                for (Map.Entry entry : allTempParams.entrySet()) {
                    if (entry.getKey() == null || !value.contains("${" + (String)entry.getKey() + "}")) continue;
                    value = value.replace("${" + (String)entry.getKey() + "}", (CharSequence)((List)entry.getValue()).get(0));
                }
            }
            if (integration != null && integration.getPropSheet() != null && value != null) {
                for (PropValue propvalue : integration.getPropSheet().getPropValueList()) {
                    if (!value.contains("${" + propvalue.getName() + "}")) continue;
                    value = value.replace("${" + propvalue.getName() + "}", propvalue.getValue());
                }
            }
        }
        return value;
    }

    public Boolean isIntegrationRunning(UUID integrationId) {
        Boolean result = this.runningIntegrationsMap.get(integrationId);
        if (result == null) {
            result = false;
        }
        return result;
    }

    public void setIntegrationToRunning(UUID integrationId) {
        this.runningIntegrationsMap.put(integrationId, true);
    }

    public void setIntegrationToNotRunning(UUID integrationId) {
        this.runningIntegrationsMap.put(integrationId, false);
    }
}

