/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.plugin;

import com.ibm.cloud.urbancode.sync.models.Named;
import com.ibm.cloud.urbancode.sync.plugin.Command;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

public abstract class Plugin
extends Named
implements Comparable<Plugin> {
    @Transient
    private String docType = "plugin";
    private String description = null;
    private String pluginId;
    private Long pluginVersion = null;
    private String releaseVersion;
    private String pluginHash = null;
    @OneToMany(mappedBy="plugin")
    @Cascade(value={CascadeType.ALL})
    private SortedSet<Command> commands = new TreeSet<Command>();
    private String tag;
    private String type;

    public static String getPluginFileName(String pluginId, Long pluginVersion) {
        String result = pluginId + "_" + pluginVersion + ".zip";
        return result;
    }

    public static String getPluginHashName(String pluginId, Long pluginVersion) {
        String result = pluginId + "_" + pluginVersion + ".hash";
        return result;
    }

    public Plugin() {
    }

    protected Plugin(String pluginId, Long pluginVersion) {
        this.pluginId = pluginId;
        this.pluginVersion = pluginVersion;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    public Long getPluginVersion() {
        return this.pluginVersion;
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    public void setReleaseVersion(String releaseVersion) {
        this.releaseVersion = releaseVersion;
    }

    public String getPluginHash() {
        return this.pluginHash;
    }

    public void setPluginHash(String pluginHash) {
        this.pluginHash = pluginHash;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isDeletable() {
        return !this.getPluginId().startsWith("com.urbancode.");
    }

    public void addCommand(Command step) {
        this.commands.add(step);
    }

    protected void removeCommand(Command step) {
        this.commands.remove(step);
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getType() {
        return this.type;
    }

    protected void setType(String type) {
        this.type = type;
    }

    public SortedSet<Command> getCommands() {
        return Collections.unmodifiableSortedSet(this.commands);
    }

    public Command getDefaultDisplayableStep() {
        Command defaultStep = null;
        for (Command cmd : this.commands) {
            if (!cmd.isDisplayed()) continue;
            defaultStep = cmd;
        }
        return defaultStep;
    }

    public Command getCommandByName(String name) {
        Command result = null;
        for (Command command : this.getCommands()) {
            if (!command.getName().equals(name)) continue;
            result = command;
            break;
        }
        return result;
    }
}

