/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.plugin;

import com.ibm.cloud.urbancode.sync.SyncApplicationProperties;
import com.ibm.cloud.urbancode.sync.models.Integration;
import com.ibm.cloud.urbancode.sync.persistence.cloud.IntegrationCloudDao;
import com.ibm.cloud.urbancode.sync.plugin.quartz.IntegrationRunner;
import com.ibm.cloud.urbancode.sync.plugin.quartz.JobSchedulerFactory;
import com.urbancode.air.i18n.TranslateUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.quartz.JobDataMap;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component(value="IntegrationService")
public class IntegrationService {
    private static final Logger log = Logger.getLogger(IntegrationService.class);
    private IntegrationCloudDao dao;
    private JobSchedulerFactory factory;
    private int frequency = 1;

    @Inject
    public IntegrationService(IntegrationCloudDao dao, JobSchedulerFactory factory, @Value(value="#{systemProperties['integration.frequency'] ?: 1}") Integer frequency) {
        this.dao = dao;
        this.factory = factory;
        if (frequency != null && frequency > 0) {
            this.frequency = frequency;
        }
        log.info((Object)("Integrations will run every " + frequency + (frequency == 1 ? " minute" : " minutes")));
    }

    @EventListener
    public void start(ContextRefreshedEvent event) {
        Properties props = SyncApplicationProperties.getProperties();
        String syncId = props.getProperty("sync.id");
        String syncToken = props.getProperty("sync.token");
        if (StringUtils.isBlank((CharSequence)syncId) || StringUtils.isBlank((CharSequence)syncToken)) {
            return;
        }
        List<Object> providers = new ArrayList();
        try {
            providers = this.dao.getAll();
            if (providers != null) {
                for (Integration integration : providers) {
                    this.schedule(integration);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)(TranslateUtil.i18n((String)"Can not schedule jobs for the list of providers ", (Object[])new Object[0]) + e.getMessage()));
        }
    }

    public void schedule(Integration integration) throws Exception {
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("UUID", (Object)integration.getId());
        this.factory.createOrUpdateSimpleTrigger(integration.getId(), IntegrationRunner.class, JobSchedulerFactory.TASK_GROUP_INTEGRATION, this.frequency, jobDataMap);
    }

    public void unschedule(Integration integration) throws Exception {
        if (integration.getId() != null) {
            this.factory.resetScheduledJob(integration.getId().toString(), JobSchedulerFactory.TASK_GROUP_INTEGRATION);
        }
    }
}

