/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.persistence.cloud;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ibm.cloud.urbancode.sync.models.Integration;
import com.ibm.cloud.urbancode.sync.persistence.cloud.CloudDao;
import com.ibm.cloud.urbancode.sync.persistence.cloud.ConnectorPluginRefTypeAdapter;
import com.ibm.cloud.urbancode.sync.plugin.connector.ConnectorPlugin;
import com.ibm.cloud.urbancode.sync.resources.json.Association;
import com.ibm.cloud.urbancode.sync.resources.json.JsonSerializer;
import com.urbancode.air.property.prop_sheet.PropSheet;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class IntegrationCloudDao
extends CloudDao<Integration> {
    private static final Association[] associations = new Association[]{new Association(Integration.class, "plugin", "propSheet", "templatePropSheet"), new Association(PropSheet.class, "propSheetDefId", "propValues", "templatePropSheetId")};
    private final Gson deserializer;
    private final Map<Class<?>, Object> typeAdapterMap = new HashMap();

    @Inject
    public IntegrationCloudDao(@Value(value="${syncStoreUrl}") String baseUrl, ConnectorPluginRefTypeAdapter pluginTypeAdapter) {
        super(baseUrl);
        this.typeAdapterMap.put(ConnectorPlugin.class, (Object)pluginTypeAdapter);
        this.deserializer = new GsonBuilder().registerTypeAdapter(ConnectorPlugin.class, (Object)pluginTypeAdapter).create();
    }

    @Override
    protected String getUrlPath() {
        return "integrations";
    }

    @Override
    protected JsonSerializer getSerializer() {
        return new JsonSerializer(this.typeAdapterMap, associations);
    }

    @Override
    protected Gson getDeserializer() {
        return this.deserializer;
    }
}

