/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.persistence.cloud;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.ibm.cloud.urbancode.sync.persistence.cloud.ConnectorPluginCloudDao;
import com.ibm.cloud.urbancode.sync.plugin.connector.ConnectorPlugin;
import com.urbancode.air.i18n.TranslateUtil;
import java.io.IOException;
import java.util.UUID;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class ConnectorPluginRefTypeAdapter
extends TypeAdapter<ConnectorPlugin> {
    private final ConnectorPluginCloudDao dao;

    @Inject
    public ConnectorPluginRefTypeAdapter(ConnectorPluginCloudDao dao) {
        this.dao = dao;
    }

    public void write(JsonWriter out, ConnectorPlugin plugin) throws IOException {
        out.beginObject();
        if (plugin != null) {
            out.name("plugin_id").value(plugin.getId().toString());
        }
        out.endObject();
    }

    public ConnectorPlugin read(JsonReader in) throws IOException {
        ConnectorPlugin plugin = null;
        JsonToken nextToken = in.peek();
        if (JsonToken.BEGIN_OBJECT == nextToken) {
            in.beginObject();
            while (in.hasNext()) {
                String name = in.nextName();
                if (!"plugin_id".equals(name)) continue;
                UUID id = UUID.fromString(in.nextString());
                plugin = (ConnectorPlugin)this.dao.get(id);
            }
            in.endObject();
        } else if (JsonToken.NULL != nextToken) {
            if (JsonToken.STRING == nextToken) {
                UUID id = UUID.fromString(in.nextString());
                plugin = (ConnectorPlugin)this.dao.get(id);
            } else {
                throw new IllegalStateException(TranslateUtil.i18n((String)"Input for an associated object should be null, a string, or an object with an 'id' property", (Object[])new Object[0]));
            }
        }
        return plugin;
    }
}

