/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.persistence.cloud;

import com.google.gson.Gson;
import com.ibm.cloud.urbancode.sync.persistence.cloud.CloudDao;
import com.ibm.cloud.urbancode.sync.plugin.Command;
import com.ibm.cloud.urbancode.sync.plugin.Plugin;
import com.ibm.cloud.urbancode.sync.plugin.UICommandDefinition;
import com.ibm.cloud.urbancode.sync.plugin.UIFieldDefinition;
import com.ibm.cloud.urbancode.sync.plugin.connector.ConnectorPlugin;
import com.ibm.cloud.urbancode.sync.resources.json.Association;
import com.ibm.cloud.urbancode.sync.resources.json.JsonSerializer;
import com.urbancode.air.property.prop_def.PropDef;
import com.urbancode.air.property.prop_sheet_def.PropSheetDef;
import com.urbancode.persistence.PersistenceException;
import java.io.IOException;
import java.net.URI;
import javax.inject.Inject;
import javax.ws.rs.core.UriBuilder;
import okhttp3.Response;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ConnectorPluginCloudDao
extends CloudDao<ConnectorPlugin> {
    private static final Association[] associations = new Association[]{new Association(Plugin.class, "commands"), new Association(Command.class, "propSheetDef", "type", "uiCommandDefinition"), new Association(PropSheetDef.class, "propDefs"), new Association(UICommandDefinition.class, "propSheetDef", "fields"), new Association(UIFieldDefinition.class, "propDef"), new Association(PropDef.class, "allowedValues", "httpPropInfo", "scriptedPropInfo")};
    private static final Gson deserializer = new Gson();

    @Inject
    public ConnectorPluginCloudDao(@Value(value="${syncStoreUrl}") String baseUrl) {
        super(baseUrl);
    }

    @Override
    protected String getUrlPath() {
        return "plugins";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Plugin getPlugin(String pluginId, Long pluginVersion) {
        ConnectorPlugin connectorPlugin;
        URI url = UriBuilder.fromUri((String)this.baseUrl).path(this.getUrlPath()).path(pluginId).path(pluginVersion.toString()).build(new Object[0]);
        Response response = this.httpGet(url.toString());
        try {
            ConnectorPlugin plugin;
            connectorPlugin = plugin = (ConnectorPlugin)new Gson().fromJson(response.body().charStream(), this.type);
        }
        catch (Throwable throwable) {
            try {
                response.body().close();
                throw throwable;
            }
            catch (IOException e) {
                throw new PersistenceException((Throwable)e);
            }
        }
        response.body().close();
        return connectorPlugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Plugin getLatestPluginVersion(String pluginId) {
        ConnectorPlugin connectorPlugin;
        URI url = UriBuilder.fromUri((String)this.baseUrl).path(this.getUrlPath()).path(pluginId).build(new Object[0]);
        Response response = this.httpGet(url.toString());
        try {
            ConnectorPlugin plugin;
            connectorPlugin = plugin = (ConnectorPlugin)new Gson().fromJson(response.body().charStream(), this.type);
        }
        catch (Throwable throwable) {
            try {
                response.body().close();
                throw throwable;
            }
            catch (IOException e) {
                throw new PersistenceException((Throwable)e);
            }
        }
        response.body().close();
        return connectorPlugin;
    }

    @Override
    public JsonSerializer getSerializer() {
        return new JsonSerializer(null, associations);
    }

    @Override
    protected Gson getDeserializer() {
        return deserializer;
    }
}

