/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.persistence.cloud;

import com.google.gson.Gson;
import com.ibm.cloud.urbancode.sync.SyncApplicationProperties;
import com.ibm.cloud.urbancode.sync.models.CSEntity;
import com.ibm.cloud.urbancode.sync.resources.json.JsonSerializer;
import com.urbancode.persistence.PersistenceException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import javax.ws.rs.core.UriBuilder;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public abstract class CloudDao<T extends CSEntity> {
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    protected final OkHttpClient client;
    protected final String baseUrl;
    protected final Class<T> type;
    protected final Class<? extends T[]> arrayType;

    public CloudDao(String baseUrl) {
        this.baseUrl = baseUrl;
        Type superclass = this.getClass().getGenericSuperclass();
        if (!(superclass instanceof ParameterizedType)) {
            throw new RuntimeException("Invalid DAO: defined using raw type");
        }
        ParameterizedType ptype = (ParameterizedType)superclass;
        Type typeArg = ptype.getActualTypeArguments()[0];
        if (!(typeArg instanceof Class)) {
            throw new RuntimeException("Invalid DAO: entity type is not a simple class");
        }
        this.type = (Class)typeArg;
        this.arrayType = Array.newInstance(this.type, 0).getClass();
        this.client = new OkHttpClient.Builder().addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = chain.request();
                Properties props = SyncApplicationProperties.getProperties();
                String syncId = props.getProperty("sync.id");
                String syncToken = props.getProperty("sync.token");
                String credentials = Credentials.basic((String)syncId, (String)syncToken);
                Request authenticatedRequest = request.newBuilder().header("Authorization", credentials).build();
                return chain.proceed(authenticatedRequest);
            }
        }).build();
    }

    protected abstract String getUrlPath();

    protected abstract JsonSerializer getSerializer();

    protected abstract Gson getDeserializer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T get(UUID id) {
        try {
            URI url = UriBuilder.fromUri((String)this.baseUrl).path(this.getUrlPath()).path(id.toString()).build(new Object[0]);
            Response response = this.httpGet(url.toString());
            if (response.code() != 200) {
                if (response.code() != 404) throw new PersistenceException("Get failed. Received unexpected status code: " + response.code());
                return null;
            }
            try {
                CSEntity t;
                CSEntity cSEntity = t = (CSEntity)this.getDeserializer().fromJson(response.body().charStream(), this.type);
                return (T)cSEntity;
            }
            finally {
                response.body().close();
            }
        }
        catch (IOException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public T create(T t) {
        try {
            URI url = UriBuilder.fromUri((String)this.baseUrl).path(this.getUrlPath()).build(new Object[0]);
            Response response = this.httpPost(url.toString(), t);
            if (response.code() == 201) {
                return t;
            }
            throw new PersistenceException("Create failed. Received unexpected status code: " + response.code());
        }
        catch (IOException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public T update(T t) {
        try {
            URI url = UriBuilder.fromUri((String)this.baseUrl).path(this.getUrlPath()).path(((CSEntity)t).getId().toString()).build(new Object[0]);
            Response response = this.httpPut(url.toString(), t);
            if (response.code() == 204) {
                return t;
            }
            throw new PersistenceException("Create failed. Received unexpected status code: " + response.code());
        }
        catch (IOException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void delete(T t) {
        try {
            URI url = UriBuilder.fromUri((String)this.baseUrl).path(this.getUrlPath()).path(((CSEntity)t).getId().toString()).build(new Object[0]);
            Response response = this.httpDelete(url.toString());
            if (response.code() != 204) {
                throw new PersistenceException("Delete failed. Received unexpected status code: " + response.code());
            }
        }
        catch (IOException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getAll() {
        List<CSEntity> list;
        URI url = UriBuilder.fromUri((String)this.baseUrl).path(this.getUrlPath()).build(new Object[0]);
        Response response = this.httpGet(url.toString());
        try {
            CSEntity[] all = (CSEntity[])this.getDeserializer().fromJson(response.body().charStream(), this.arrayType);
            list = all == null ? null : Arrays.asList(all);
        }
        catch (Throwable throwable) {
            try {
                response.body().close();
                throw throwable;
            }
            catch (IOException e) {
                throw new PersistenceException((Throwable)e);
            }
        }
        response.body().close();
        return list;
    }

    protected Response httpGet(String url) throws IOException {
        Request request = new Request.Builder().url(url).build();
        Response response = this.client.newCall(request).execute();
        return response;
    }

    protected Response httpDelete(String url) throws IOException {
        Request request = new Request.Builder().url(url).delete().build();
        Response response = this.client.newCall(request).execute();
        return response;
    }

    protected Response httpPost(String url, T t) throws IOException {
        JsonSerializer serializer = this.getSerializer();
        String json = serializer.toJson(t);
        RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
        Request request = new Request.Builder().url(url).post(body).build();
        Response response = this.client.newCall(request).execute();
        return response;
    }

    protected Response httpPut(String url, T t) throws IOException {
        JsonSerializer serializer = this.getSerializer();
        String json = serializer.toJson(t);
        RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
        Request request = new Request.Builder().url(url).put(body).build();
        Response response = this.client.newCall(request).execute();
        return response;
    }
}

