/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.models;

import com.ibm.cloud.urbancode.sync.models.Described;
import com.ibm.cloud.urbancode.sync.models.WithPropSheet;
import com.ibm.cloud.urbancode.sync.models.WithPropSheetDef;
import com.ibm.cloud.urbancode.sync.plugin.Command;
import com.ibm.cloud.urbancode.sync.plugin.connector.ConnectorPlugin;
import com.ibm.cloud.urbancode.sync.resources.CSResource;
import com.ibm.cloud.urbancode.sync.resources.json.JsonHidden;
import com.ibm.cloud.urbancode.sync.resources.json.JsonReadOnly;
import com.urbancode.air.property.prop_sheet.PropSheet;
import com.urbancode.air.property.prop_sheet_def.PropSheetDef;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.apache.log4j.Logger;

public class Integration
extends Described
implements WithPropSheet,
WithPropSheetDef {
    private static final Logger log = Logger.getLogger(Integration.class);
    @Transient
    private String docType = "integration";
    @ManyToOne
    private ConnectorPlugin plugin = null;
    private String defaultStep;
    @ManyToOne
    @JsonHidden
    private PropSheet propSheet = new PropSheet();
    private Long lastExecution = new Date().getTime();
    @JsonHidden
    private String lastExecutionReport;
    @JsonReadOnly
    private String lastExecutionStatus;
    @JsonReadOnly
    private String currentState;
    @Transient
    public List<String> executionReport = new ArrayList<String>();

    public List<String> getExecutionReport() {
        return this.executionReport;
    }

    @Override
    public PropSheet getPropSheet() {
        return this.propSheet;
    }

    @Override
    public PropSheetDef getPropSheetDef() {
        ConnectorPlugin plugin = this.getPlugin();
        if (plugin == null) {
            return null;
        }
        Command commandToRun = plugin.getCommandByName(this.getDefaultStep());
        if (commandToRun == null) {
            for (Command command : plugin.getCommands()) {
                if (!command.isDisplayed()) continue;
                commandToRun = command;
            }
        }
        if (commandToRun == null) {
            return null;
        }
        return commandToRun.getPropSheetDef();
    }

    public String getLastExecutionReport() {
        return this.lastExecutionReport;
    }

    public void setLastExecutionReport(String lastExecutionReport) {
        this.lastExecutionReport = lastExecutionReport;
    }

    public Long getLastExecution() {
        return this.lastExecution;
    }

    public void setLastExecution(Long lastExecution) {
        this.lastExecution = lastExecution;
    }

    public void setCurrentState(String currentState) {
        this.currentState = currentState;
    }

    public void setExecutionReport(List<String> executionReport) {
        this.executionReport = executionReport;
    }

    public void setLastExecutionStatus(String lastExecutionStatus) {
        this.lastExecutionStatus = lastExecutionStatus;
    }

    public String getDefaultStep() {
        return this.defaultStep;
    }

    public void addLog(String className, String trace) {
        this.executionReport.add("{\"className\": \"" + className + "\", \"text\": \"" + this.sanitizeLog(trace) + "\"}");
        log.debug((Object)trace);
    }

    private String sanitizeLog(String log) {
        log = log.replace("\"", "");
        log = log.replace("\t", "");
        log = log.replace("\\", "/");
        log = CSResource.stripBidi(log);
        return log;
    }

    public ConnectorPlugin getPlugin() {
        return this.plugin;
    }

    public void setPlugin(ConnectorPlugin plugin) {
        this.plugin = plugin;
    }

    public static enum LogType {
        INFO,
        WARNING,
        TRACE,
        ERROR;

    }

    public static enum LastExecutionStatuses {
        Failed,
        Success;

    }

    public static enum CurrentStates {
        Running,
        Finished;

    }
}

