/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.cloud;

import com.ibm.cloud.urbancode.sync.cloud.CloudWorkRequest;
import com.ibm.cloud.urbancode.sync.cloud.CloudWorkRequester;
import com.ibm.cloud.urbancode.sync.cloud.CloudWorkRunnable;
import com.ibm.cloud.urbancode.sync.cloud.CoudWorkCallable;
import com.ibm.cloud.urbancode.sync.cloud.WorkResult;
import com.ibm.cloud.urbancode.sync.cloud.WorkStatus;
import com.ibm.cloud.urbancode.sync.models.Integration;
import com.ibm.cloud.urbancode.sync.persistence.cloud.ConnectorPluginCloudDao;
import com.ibm.cloud.urbancode.sync.persistence.cloud.IntegrationCloudDao;
import com.ibm.cloud.urbancode.sync.plugin.Command;
import com.ibm.cloud.urbancode.sync.plugin.Plugin;
import com.ibm.cloud.urbancode.sync.plugin.PluginHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginCommandCoudWorkCallable
extends CoudWorkCallable {
    private static final Logger log = LoggerFactory.getLogger(PluginCommandCoudWorkCallable.class);
    private final ConnectorPluginCloudDao pluginDao;
    private final IntegrationCloudDao integrationsDao;
    private final PluginHelper helper;
    private final ExecutorService executor;

    public PluginCommandCoudWorkCallable(ConnectorPluginCloudDao pluginDao, IntegrationCloudDao integrationsDao, PluginHelper helper, ExecutorService executor, CloudWorkRequester requester, JSONObject work, String id) {
        super(requester, work, id);
        this.pluginDao = pluginDao;
        this.integrationsDao = integrationsDao;
        this.helper = helper;
        this.executor = executor;
    }

    @Override
    public WorkResult call() {
        try {
            String pluginId = this.work.optString("plugin_id");
            String pluginCommand = this.work.getString("plugin_command");
            String integrationId = this.work.optString("integration_id");
            log.info("Processing work request {} to run command {} of plugin {}", new Object[]{this.id, pluginCommand, pluginId});
            JSONObject props = this.work.optJSONObject("props");
            JSONObject env = this.work.optJSONObject("env");
            Plugin plugin = this.pluginDao.getLatestPluginVersion(pluginId);
            if (plugin == null) {
                throw new Exception("Plugin with id '" + pluginId + "' not found");
            }
            Command command = plugin.getCommandByName(pluginCommand);
            if (command == null) {
                throw new Exception("Command with name '" + pluginCommand + "' not found on plugin with id '" + pluginId + "'");
            }
            UUID integrationUuid = null;
            Integration integration = null;
            if (StringUtils.isNotBlank((String)integrationId)) {
                try {
                    integrationUuid = UUID.fromString(integrationId);
                }
                catch (IllegalArgumentException e) {
                    throw new Exception("Integration id '" + integrationId + "' invalid");
                }
                integration = (Integration)this.integrationsDao.get(integrationUuid);
                if (integration == null) {
                    throw new Exception("Integration id '" + integrationId + "' not found");
                }
            }
            HashMap<String, String> pluginProps = new HashMap<String, String>();
            HashMap<String, String> envProps = new HashMap<String, String>();
            this.jsonToMap(props, pluginProps);
            this.jsonToMap(env, envProps);
            CloudWorkRequest request = new CloudWorkRequest(this.requester, this.helper, this.pluginDao, plugin.getId(), command.getName(), null, pluginProps, this.integrationsDao, integrationUuid, this.id);
            this.executor.execute(new CloudWorkRunnable(request));
            return new WorkResult(WorkStatus.started, "");
        }
        catch (Exception e) {
            log.error("Failed to execute work reqeust", (Throwable)e);
            return new WorkResult(WorkStatus.failed, e.toString());
        }
    }

    void jsonToMap(JSONObject json, Map<String, String> map) throws JSONException {
        if (json == null) {
            return;
        }
        Iterator keys = json.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = json.getString(key);
            map.put(key, value);
        }
    }
}

