/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.cloud;

import com.ibm.cloud.urbancode.sync.cloud.CloudWorkRequest;
import com.ibm.cloud.urbancode.sync.cloud.CloudWorkRequester;
import com.ibm.cloud.urbancode.sync.cloud.WorkResult;
import com.ibm.cloud.urbancode.sync.cloud.WorkStatus;
import com.ibm.cloud.urbancode.sync.plugin.PluginRunner;
import java.io.ByteArrayInputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudWorkRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(CloudWorkRunnable.class);
    private final CloudWorkRequest request;

    public CloudWorkRunnable(CloudWorkRequest request) {
        this.request = request;
    }

    @Override
    public void run() {
        String id = this.request.getId();
        CloudWorkRequester requester = this.request.getRequester();
        try {
            Map<String, String> result = this.request.execute();
            Properties outProps = new Properties();
            outProps.load(new ByteArrayInputStream(result.get(PluginRunner.RESULT_PROPS).getBytes()));
            int exitCode = Integer.parseInt(outProps.getProperty("exitCode", "-1"));
            String status = outProps.getProperty("Status");
            log.info("Status: {}", (Object)status);
            log.info("Exit Code: {}", (Object)exitCode);
            log.info("Output:\n{}", (Object)result.get(PluginRunner.RESULT_STD_OUT));
            String error = result.get(PluginRunner.RESULT_STD_ERR);
            if (StringUtils.isNotBlank((String)error)) {
                log.info("Error:\n{}", (Object)error);
            }
            if ("Success".equalsIgnoreCase(status)) {
                log.info("Work request {} completed with {}", (Object)id, (Object)WorkStatus.success);
                requester.sendResult(id, new WorkResult(WorkStatus.success, ""));
            } else {
                log.info("Work request {} completed with {}, exit code {}", new Object[]{id, WorkStatus.failed, exitCode});
                requester.sendResult(id, new WorkResult(WorkStatus.failed, "Failed with status '" + status + "' and exit code " + exitCode));
            }
        }
        catch (Exception e) {
            log.error("Error processing work item", (Throwable)e);
            requester.sendResult(id, new WorkResult(WorkStatus.failed, e.toString()));
        }
    }
}

