/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.cloud;

import com.ibm.cloud.urbancode.sync.cloud.CloudWorkRequester;
import com.ibm.cloud.urbancode.sync.models.Integration;
import com.ibm.cloud.urbancode.sync.persistence.cloud.ConnectorPluginCloudDao;
import com.ibm.cloud.urbancode.sync.persistence.cloud.IntegrationCloudDao;
import com.ibm.cloud.urbancode.sync.plugin.Command;
import com.ibm.cloud.urbancode.sync.plugin.Plugin;
import com.ibm.cloud.urbancode.sync.plugin.PluginHelper;
import java.util.Map;
import java.util.UUID;

public class CloudWorkRequest {
    private final CloudWorkRequester requester;
    private final PluginHelper helper;
    private final ConnectorPluginCloudDao dao;
    private final UUID pluginId;
    private final String commandName;
    private final String source;
    private final Map<String, String> params;
    private final IntegrationCloudDao integrationsDao;
    private final UUID integrationId;
    private final String id;

    public CloudWorkRequest(CloudWorkRequester requester, PluginHelper helper, ConnectorPluginCloudDao dao, UUID pluginId, String commandName, String source, Map<String, String> params, IntegrationCloudDao integrationsDao, UUID integrationId, String id) {
        this.requester = requester;
        this.helper = helper;
        this.dao = dao;
        this.pluginId = pluginId;
        this.commandName = commandName;
        this.source = source;
        this.params = params;
        this.integrationsDao = integrationsDao;
        this.integrationId = integrationId;
        this.id = id;
    }

    public CloudWorkRequester getRequester() {
        return this.requester;
    }

    public Map<String, String> execute() throws Exception {
        Plugin plugin = (Plugin)this.dao.get(this.pluginId);
        Command command = plugin.getCommandByName(this.commandName);
        Integration integration = null;
        if (this.integrationId != null) {
            integration = (Integration)this.integrationsDao.get(this.integrationId);
        }
        return this.helper.executeStep(plugin, command, this.source, this.params, integration, false);
    }

    public String getId() {
        return this.id;
    }
}

