/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.cloud;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.ibm.cloud.urbancode.connect.client.ConnectSocket;
import com.ibm.cloud.urbancode.sync.cloud.CloudWorkCallableFactory;
import com.ibm.cloud.urbancode.sync.cloud.CloudWorkRequester;
import com.ibm.cloud.urbancode.sync.cloud.IWorkListener;
import com.ibm.cloud.urbancode.sync.cloud.WorkResult;
import com.ibm.cloud.urbancode.sync.cloud.WorkStatus;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="WorkListener")
public class CloudWorkListener
implements IWorkListener {
    private static final Logger log = LoggerFactory.getLogger(CloudWorkListener.class);
    private final CloudWorkCallableFactory factory;
    private final Cache<String, WorkResult> workResultCache;

    @Autowired
    public CloudWorkListener(CloudWorkCallableFactory factory) {
        this.factory = factory;
        this.workResultCache = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.MINUTES).build();
    }

    public void call(ConnectSocket socket, String event, Object ... args) {
        CloudWorkRequester requester = new CloudWorkRequester(socket);
        JSONArray workArray = (JSONArray)args[0];
        log.info("Received " + workArray.length() + " cloud work requests");
        for (int i = 0; i < workArray.length(); ++i) {
            try {
                JSONObject work = workArray.getJSONObject(i);
                String id = work.getString("id");
                boolean ignoreCache = work.optBoolean("ignore_cache");
                String type = work.optString("type");
                try {
                    WorkResult result;
                    if (ignoreCache) {
                        result = (WorkResult)this.factory.createCallable(type, requester, work, id).call();
                        this.workResultCache.put((Object)id, (Object)result);
                    } else {
                        result = (WorkResult)this.workResultCache.get((Object)id, (Callable)this.factory.createCallable(type, requester, work, id));
                    }
                    requester.sendResult(id, result);
                }
                catch (Exception e) {
                    log.error("Cloud work request failed", (Throwable)e);
                    requester.sendResult(id, new WorkResult(WorkStatus.failed, e.toString()));
                }
                continue;
            }
            catch (JSONException e) {
                log.error("Received a work request that could not be parsed. Unable to fail the request", (Throwable)e);
            }
        }
    }
}

