/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.cloud;

import com.ibm.cloud.urbancode.sync.cloud.CloudWorkRequester;
import com.ibm.cloud.urbancode.sync.cloud.CoudWorkCallable;
import com.ibm.cloud.urbancode.sync.cloud.PluginCommandCoudWorkCallable;
import com.ibm.cloud.urbancode.sync.persistence.cloud.ConnectorPluginCloudDao;
import com.ibm.cloud.urbancode.sync.persistence.cloud.IntegrationCloudDao;
import com.ibm.cloud.urbancode.sync.plugin.PluginHelper;
import com.urbancode.commons.util.concurrent.NamedThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="WorkStatusCallableFactory")
public class CloudWorkCallableFactory {
    private final ConnectorPluginCloudDao pluginDao;
    private final IntegrationCloudDao integrationsDao;
    private final PluginHelper helper;
    private final ExecutorService executor;

    @Autowired
    public CloudWorkCallableFactory(ConnectorPluginCloudDao pluginDao, IntegrationCloudDao integrationsDao, PluginHelper helper, @Value(value="${maxExecutionThreads}") int maxThreads) {
        this.pluginDao = pluginDao;
        this.integrationsDao = integrationsDao;
        this.helper = helper;
        NamedThreadFactory threadFactory = new NamedThreadFactory("WorkListener", NamedThreadFactory.ThreadMode.NON_DAEMON);
        this.executor = new ThreadPoolExecutor(1, maxThreads, 600L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)threadFactory);
    }

    CoudWorkCallable createCallable(String type, CloudWorkRequester requester, JSONObject work, String id) throws Exception {
        if (StringUtils.isEmpty((String)type) || "plugin".equalsIgnoreCase(type)) {
            return new PluginCommandCoudWorkCallable(this.pluginDao, this.integrationsDao, this.helper, this.executor, requester, work, id);
        }
        throw new Exception("Unrecognized work type: " + type);
    }
}

