/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.cloud;

import com.ibm.cloud.urbancode.connect.client.ConnectSocket;
import com.ibm.cloud.urbancode.connect.client.Listener;
import com.ibm.cloud.urbancode.connect.client.Listeners;
import com.ibm.cloud.urbancode.sync.SyncApplicationProperties;
import com.ibm.cloud.urbancode.sync.cloud.IWorkListener;
import com.ibm.cloud.urbancode.sync.plugin.PluginInitialization;
import java.net.URI;
import java.util.Properties;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component(value="CloudSocketComponent")
public class CloudSocketComponent {
    public static final Logger log = LoggerFactory.getLogger(CloudSocketComponent.class);
    private final IWorkListener workListener;
    private final String cloudUrl;
    private final PluginInitialization plugins;
    private ConnectSocket socket;

    @Inject
    public CloudSocketComponent(IWorkListener workListener, @Value(value="${cloudUrl}") Object cloudUrl, PluginInitialization plugins) {
        this.workListener = workListener;
        this.cloudUrl = String.valueOf(cloudUrl);
        this.plugins = plugins;
    }

    public boolean isRegistered() {
        return StringUtils.isNotBlank((CharSequence)this.getSyncToken());
    }

    public String getSyncId() {
        Properties props = SyncApplicationProperties.getProperties();
        return props.getProperty("sync.id");
    }

    public String getSyncToken() {
        Properties props = SyncApplicationProperties.getProperties();
        return props.getProperty("sync.token");
    }

    public void setRegistration(String syncToken, String registrar) throws Exception {
        Properties props = SyncApplicationProperties.getProperties();
        props.setProperty("sync.token", syncToken);
        if (StringUtils.isNotBlank((CharSequence)registrar)) {
            props.setProperty("sync.registrar", registrar);
        }
        SyncApplicationProperties.writeProperties();
        this.connectToCloudServices();
    }

    @EventListener
    public void start(ContextRefreshedEvent event) throws Exception {
        this.connectToCloudServices();
    }

    public void connectToCloudServices() throws Exception {
        String syncId = this.getSyncId();
        String syncToken = this.getSyncToken();
        if (StringUtils.isBlank((CharSequence)syncId) || StringUtils.isBlank((CharSequence)syncToken)) {
            log.info("Not connecting to the cloud. Cloud Sync not registered yet.");
            return;
        }
        URI uri = new URI(this.cloudUrl);
        log.info("Starting cloud endpoint " + syncId);
        this.socket = ConnectSocket.builder().uri(uri).id(syncId).token(syncToken).onConnect(Listeners.chain((Listener)Listeners.INFO_LOGGING, (Listener)Listeners.EMIT_GET_WORK)).onDisconnect(Listeners.INFO_LOGGING).onWorkAvailable(Listeners.chain((Listener)Listeners.DEBUG_LOGGING, (Listener)Listeners.EMIT_GET_WORK)).onWork((Listener)this.workListener).onError(Listeners.ERROR_LOGGING).build();
        this.socket.on("connect_error", Listeners.ERROR_LOGGING);
        this.socket.on("connect_timeout", Listeners.ERROR_LOGGING);
        this.socket.on("reconnect_error", Listeners.ERROR_LOGGING);
        this.socket.on("reconnect_failed", Listeners.ERROR_LOGGING);
        this.socket.on("reconnect_attempt", Listeners.INFO_LOGGING);
        log.info("Connecting to cloud service at {}", (Object)uri);
        this.socket.connect();
        this.plugins.getPluginInitializationRunnable().run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void disconnect() {
        if (this.socket != null) {
            try {
                this.socket.disconnect();
                log.info("Disconnected from the cloud service");
            }
            catch (Exception e) {
                log.error("Error disconnecting the cloud service gracefully", (Throwable)e);
            }
            finally {
                this.socket = null;
            }
        }
    }
}

