/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync;

import com.ibm.cloud.urbancode.sync.SyncApplication;
import com.ibm.cloud.urbancode.sync.util.ResourceUtil;
import com.ibm.cloud.urbancode.sync.util.UnzipUtil;
import com.urbancode.air.plugin_command.Utils;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;

@Component
public class WinApiInstallation {
    public static final Logger log = LoggerFactory.getLogger(WinApiInstallation.class);
    private final SyncApplication app;
    private final ResourceLoader resourceLoader;

    @Inject
    public WinApiInstallation(SyncApplication app, ResourceLoader resourceLoader) {
        this.app = app;
        this.resourceLoader = resourceLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void installNativeIfNeeded() {
        File storageDir = this.app.getStorageDir();
        File nativeDir = new File(storageDir, "native");
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        if (osName != null && osName.contains("windows") && !nativeDir.isDirectory()) {
            log.info("Extracting WinApi native libraries to {}", (Object)nativeDir);
            try {
                String resourcePath = "classpath:tools/winapi-native.zip";
                File file = new File(storageDir, "winapi-native.zip");
                ResourceUtil.extractResource(this.resourceLoader, resourcePath, file);
                try {
                    UnzipUtil.unzip(file, nativeDir);
                }
                finally {
                    file.delete();
                }
                log.info("Extracted WinApi native libraries to {}", (Object)nativeDir);
            }
            catch (IOException e) {
                log.error("Error extracting WinApi native libraries", (Throwable)e);
                return;
            }
        }
        String arch = Utils.getArch();
        if (osName != null && osName.contains("windows") && System.getProperty("com.urbancode.winapi.WinAPI.dllPath") == null) {
            File archDir = new File(nativeDir, arch);
            File libraryPath = new File(archDir, "WinAPI.dll").getAbsoluteFile();
            if (!libraryPath.isFile()) {
                throw new RuntimeException("Could not find native architecture libraries at '" + libraryPath.getAbsolutePath() + "'.");
            }
            System.setProperty("com.urbancode.winapi.WinAPI.dllPath", libraryPath.getAbsolutePath());
        }
    }
}

