/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class SyncApplicationProperties {
    public static final String INSTALLATION_DIR_PROP = "sync.installation.dir";
    public static final String SYNC_ID = "sync.id";
    public static final String SYNC_TOKEN = "sync.token";
    public static final String SYNC_REGISTRAR = "sync.registrar";
    public static final String SYNC_USERS = "sync.users";
    public static final String HA_ENABLED = "ha.enabled";
    private static File propsFile;
    private static Properties props;

    public static synchronized Properties loadProperties(File storageDir) throws IOException {
        props = new Properties();
        propsFile = new File(storageDir, "sync.properties");
        if (propsFile.exists() && propsFile.isFile()) {
            props.load(new FileInputStream(propsFile));
            SyncApplicationProperties.setSystemProperties();
        } else {
            SyncApplicationProperties.writeProperties();
        }
        return props;
    }

    public static synchronized void writeProperties() throws IOException {
        props.store(new FileWriter(propsFile), null);
        SyncApplicationProperties.setSystemProperties();
    }

    private static void setSystemProperties() {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            System.setProperty(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
    }

    public static Properties getProperties() {
        return props;
    }
}

