/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync;

import com.ibm.cloud.urbancode.sync.SyncApplicationProperties;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.core.annotation.Order;

@SpringBootApplication(exclude={DataSourceAutoConfiguration.class, HibernateJpaAutoConfiguration.class})
@Order(value=1)
public class SyncApplication {
    public static final Logger log = LoggerFactory.getLogger(SyncApplication.class);
    private File storageDir;

    public static void main(String[] args) throws Exception {
        SpringApplication.run(SyncApplication.class, (String[])args);
    }

    @PostConstruct
    public void postConstruct() throws IOException {
        this.initStorageDir();
        Properties props = SyncApplicationProperties.loadProperties(this.storageDir);
        String syncId = props.getProperty("sync.id");
        if (StringUtils.isBlank((CharSequence)syncId)) {
            syncId = UUID.randomUUID().toString();
            props.setProperty("sync.id", syncId);
            SyncApplicationProperties.writeProperties();
        }
    }

    @PreDestroy
    public void preDestroy() {
    }

    void initStorageDir() {
        if (StringUtils.isNotBlank((CharSequence)System.getProperty("sync.installation.dir"))) {
            this.storageDir = new File(System.getProperty("sync.installation.dir"));
        } else {
            File userHome = new File(System.getProperty("user.home"));
            this.storageDir = new File(userHome, ".ibm/cloud-sync");
            System.setProperty("sync.installation.dir", this.storageDir.getAbsolutePath());
        }
        if (!this.storageDir.exists()) {
            this.storageDir.mkdirs();
        }
        log.info("Using data directory: " + this.storageDir);
    }

    public File getStorageDir() {
        if (this.storageDir == null) {
            this.initStorageDir();
        }
        return this.storageDir;
    }
}

