/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync;

import com.ibm.cloud.urbancode.sync.util.KeyStoreUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Random;
import javax.annotation.PostConstruct;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.bc.BcX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=2)
public class KeystoreConfiguration {
    public static final Logger log = LoggerFactory.getLogger(KeystoreConfiguration.class);
    private final String keyStoreType;
    private final String keyStorePath;
    private final String keyStorePwd;
    private final String keyAlias;

    @Autowired
    public KeystoreConfiguration(@Value(value="${server.ssl.keyStoreType}") String keyStoreType, @Value(value="${server.ssl.key-store}") String keyStorePath, @Value(value="${server.ssl.key-store-password}") String keyStorePwd, @Value(value="${server.ssl.keyAlias}") String keyAlias) {
        this.keyStoreType = keyStoreType;
        this.keyStorePath = keyStorePath;
        this.keyStorePwd = keyStorePwd;
        this.keyAlias = keyAlias;
    }

    @PostConstruct
    public void postConstruct() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyStoreUtil util = new KeyStoreUtil();
        try {
            KeyStore keyStore = util.loadKeyStore(this.keyStorePath, this.keyStoreType, this.keyStorePwd);
            if (!keyStore.isKeyEntry(this.keyAlias)) {
                X500Name issuerName;
                log.info("Creating keystore {}", (Object)this.keyStorePath);
                KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA", "BC");
                generator.initialize(2048, new SecureRandom());
                KeyPair keyPair = generator.generateKeyPair();
                PrivateKey privateKey = keyPair.getPrivate();
                PublicKey publicKey = keyPair.getPublic();
                X500Name subjectName = issuerName = new X500Name("CN=cloud-sync");
                BigInteger serial = BigInteger.valueOf(new Random().nextInt());
                JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(issuerName, serial, new Date(), new Date(253402300799000L), subjectName, publicKey);
                builder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)this.createSubjectKeyIdentifier(publicKey));
                ContentSigner sigGen = new JcaContentSignerBuilder("SHA256WithRSAEncryption").setProvider("BC").build(privateKey);
                X509Certificate cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(builder.build(sigGen));
                cert.checkValidity(new Date());
                cert.verify(publicKey);
                Certificate[] chain = new X509Certificate[]{cert};
                keyStore.setKeyEntry(this.keyAlias, privateKey, this.keyStorePwd.toCharArray(), chain);
                util.writeKeyStore(keyStore, this.keyStorePath, this.keyStorePwd);
            }
        }
        catch (Exception e) {
            log.error("Error creating keystore", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SubjectKeyIdentifier createSubjectKeyIdentifier(Key key) throws IOException {
        SubjectKeyIdentifier subjectKeyIdentifier;
        ASN1InputStream is = null;
        try {
            is = new ASN1InputStream((InputStream)new ByteArrayInputStream(key.getEncoded()));
            ASN1Sequence seq = (ASN1Sequence)is.readObject();
            SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance((Object)seq);
            subjectKeyIdentifier = new BcX509ExtensionUtils().createSubjectKeyIdentifier(info);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        return subjectKeyIdentifier;
    }
}

