/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync;

import com.ibm.cloud.urbancode.sync.SyncApplication;
import com.ibm.cloud.urbancode.sync.util.ResourceUtil;
import com.ibm.cloud.urbancode.sync.util.UnzipUtil;
import java.io.File;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;

@Component
public class GroovyInstallation {
    public static final Logger log = LoggerFactory.getLogger(GroovyInstallation.class);
    private final SyncApplication app;
    private final ResourceLoader resourceLoader;
    private String groovyHomePath;

    @Inject
    public GroovyInstallation(SyncApplication app, ResourceLoader resourceLoader) {
        this.app = app;
        this.resourceLoader = resourceLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void installGroovyIfNeeded() {
        File storageDir = this.app.getStorageDir();
        File groovyHome = new File(storageDir, "groovy-2.4.6");
        if (!groovyHome.isDirectory()) {
            log.info("Extracting Groovy to {}", (Object)groovyHome);
            try {
                String resourcePath = "classpath:tools/groovy-binary-2.4.6.zip";
                File file = new File(storageDir, "groovy-binary-2.4.6.zip");
                ResourceUtil.extractResource(this.resourceLoader, resourcePath, file);
                try {
                    UnzipUtil.unzip(file, storageDir);
                }
                finally {
                    file.delete();
                }
                log.info("Extracted Groovy to {}", (Object)groovyHome);
                this.groovyHomePath = groovyHome.getAbsolutePath();
            }
            catch (IOException e) {
                log.error("Error extracting Groovy installation", (Throwable)e);
                return;
            }
        }
        this.groovyHomePath = groovyHome.getAbsolutePath();
    }

    public String getGroovyHomePath() {
        return this.groovyHomePath;
    }
}

