/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync;

import com.ibm.cloud.urbancode.sync.util.KeyStoreUtil;
import com.urbancode.commons.util.crypto.CryptStringUtil;
import com.urbancode.commons.util.crypto.algs.Crypt1Alg;
import com.urbancode.commons.util.crypto.algs.CryptStringAlgorithm;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=2)
public class EncryptionConfiguration {
    public static final Logger log = LoggerFactory.getLogger(EncryptionConfiguration.class);
    private final String keyStoreType;
    private final String keyStorePath;
    private final String keyStorePwd;
    private final String keyAlias;

    @Autowired
    public EncryptionConfiguration(@Value(value="${server.encryption.keyStoreType}") String keyStoreType, @Value(value="${server.encryption.key-store}") String keyStorePath, @Value(value="${server.encryption.key-store-password}") String keyStorePwd, @Value(value="${server.encryption.keyAlias}") String keyAlias) {
        this.keyStoreType = keyStoreType;
        this.keyStorePath = keyStorePath;
        this.keyStorePwd = keyStorePwd;
        this.keyAlias = keyAlias;
    }

    @PostConstruct
    public void postConstruct() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyStoreUtil util = new KeyStoreUtil();
        try {
            KeyStore keyStore = util.loadKeyStore(this.keyStorePath, this.keyStoreType, this.keyStorePwd);
            if (!keyStore.isKeyEntry(this.keyAlias)) {
                log.info("Creating key " + this.keyAlias + " in " + this.keyStorePath + " for encryption");
                KeyGenerator keyGen = KeyGenerator.getInstance("AES", "BC");
                keyGen.init(128, new SecureRandom());
                SecretKey secretKey = keyGen.generateKey();
                KeyStore.SecretKeyEntry entry = new KeyStore.SecretKeyEntry(secretKey);
                keyStore.setEntry(this.keyAlias, entry, new KeyStore.PasswordProtection(this.keyStorePwd.toCharArray()));
                util.writeKeyStore(keyStore, this.keyStorePath, this.keyStorePwd);
            }
            log.info("Loading key " + this.keyAlias + " from " + this.keyStorePath + " for encryption");
            this.assertSecretKeyExists(keyStore);
            Map<String, SecretKey> keyMap = this.retrieveAliasToSecretKeyMap(keyStore, this.keyStorePwd);
            Crypt1Alg aesAlg = new Crypt1Alg(this.keyAlias, "AES/CBC/PKCS5Padding", keyMap);
            CryptStringUtil.registerCryptStringAlgorithm((CryptStringAlgorithm)aesAlg);
            CryptStringUtil.getDefaultInstance().setDefaultCryptAlg((CryptStringAlgorithm)aesAlg);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KeyStore loadKeyStore() throws Exception {
        KeyStore keyStore = KeyStore.getInstance(this.keyStoreType);
        File keyStoreFile = new File(this.keyStorePath);
        if (keyStoreFile.isFile()) {
            FileInputStream input = new FileInputStream(keyStoreFile);
            try {
                keyStore.load(null, this.keyStorePwd.toCharArray());
            }
            finally {
                IOUtils.closeQuietly((InputStream)input);
            }
        }
        return keyStore;
    }

    private SecretKey assertSecretKeyExists(KeyStore keyStore) throws GeneralSecurityException, IOException {
        Key key = keyStore.getKey(this.keyAlias, this.keyStorePwd.toCharArray());
        if (key == null) {
            throw new GeneralSecurityException("Could not retrieve encryption key from keystore. Shutting down.");
        }
        if (!(key instanceof SecretKey)) {
            StringBuilder builder = new StringBuilder();
            builder.append("Stored key was not of the expected type!");
            builder.append("\nExpected type: ");
            builder.append(SecretKey.class.getCanonicalName());
            builder.append("\nReturned type: ");
            builder.append(key.getClass().getCanonicalName());
            throw new GeneralSecurityException(builder.toString());
        }
        return (SecretKey)key;
    }

    private Map<String, SecretKey> retrieveAliasToSecretKeyMap(KeyStore keyStore, String keyStorePwd) throws GeneralSecurityException, IOException {
        HashMap<String, SecretKey> keys = new HashMap<String, SecretKey>();
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Key key = keyStore.getKey(alias, keyStorePwd.toCharArray());
            if (!(key instanceof SecretKey)) continue;
            keys.put(alias, (SecretKey)key);
        }
        return keys;
    }
}

