/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.nonull;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.immutable.IImmutableSet;
import com.urbancode.commons.util.nonull.NonNull;
import com.urbancode.commons.util.nonull.NonNullCollections;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
final class NonNullImmutableSet<T>
implements IImmutableSet<T>,
Serializable,
NonNull {
    private static final long serialVersionUID = 1L;
    private final IImmutableSet<T> delegate;

    NonNullImmutableSet(IImmutableSet<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean add(T o) {
        return this.delegate.add(o);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.delegate.addAll(c);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public IImmutableSet<T> difference(Collection<?> coll) {
        return new NonNullImmutableSet<T>(this.delegate.difference(coll));
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public T get(T key) {
        return this.delegate.get(key);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public IImmutableSet<T> intersection(Collection<?> coll) {
        IImmutableSet<T> modified = this.delegate.intersection(coll);
        if (this.delegate != modified) {
            return NonNullCollections.nonNullImmutableSet(modified);
        }
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.delegate.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.delegate.retainAll(c);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public IImmutableSet<T> union(Collection<? extends T> coll) {
        IImmutableSet<T> result = this;
        for (T t : coll) {
            result = result.with(t);
        }
        return result;
    }

    @Override
    public IImmutableSet<T> with(T element) {
        Check.nonNull(element, "element");
        IImmutableSet<T> modified = this.delegate.with(element);
        if (this.delegate != modified) {
            return NonNullCollections.nonNullImmutableSet(modified);
        }
        return this;
    }

    @Override
    public IImmutableSet<T> without(Object o) {
        IImmutableSet<T> modified = this.delegate.without(o);
        if (this.delegate != modified) {
            return NonNullCollections.nonNullImmutableSet(modified);
        }
        return this;
    }
}

