/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.util;

import com.urbancode.commons.web.util.PercentCodec;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.lang.StringUtils;

public class ContentDispositionBuilder {
    public static String CONTENT_DISPOSITION_HEADER = "Content-Disposition";
    private boolean forceDownload = true;
    private String fileName = null;

    public ContentDispositionBuilder() {
    }

    public ContentDispositionBuilder(String fileName) {
        this.setFileName(fileName);
    }

    public void setForceDownload(boolean forceDownload) {
        this.forceDownload = forceDownload;
    }

    public boolean isForceDownload() {
        return this.forceDownload;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String build() {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        if (this.forceDownload) {
            result.append("attachment");
            first = false;
        }
        if (StringUtils.isNotEmpty(this.fileName)) {
            try {
                PercentCodec codec = new PercentCodec();
                if (!first) {
                    result.append("; ");
                }
                result.append("filename*=UTF-8''" + codec.encode(this.fileName));
                first = false;
            }
            catch (EncoderException e) {
                throw new RuntimeException(e);
            }
            if (!first) {
                result.append("; ");
            }
            String asciiFilename = Java6Initializer.toASCII(this.fileName);
            result.append("filename=\"" + asciiFilename.replace("\"", "\\\"") + "\"");
            first = false;
        }
        return result.toString();
    }

    private static class Java6Initializer {
        private static Method normalize;
        private static Object NFD;

        private Java6Initializer() {
        }

        public static String toASCII(String value) {
            String result = value;
            if (normalize != null) {
                try {
                    String decomposedValue = (String)normalize.invoke(null, value, NFD);
                    result = decomposedValue.replaceAll("[\\p{InCombiningDiacriticalMarks}\\p{IsLm}\\p{IsSk}]", "");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            return result.replaceAll("[^\\p{ASCII}]", "_");
        }

        static {
            try {
                Class<?> Normalizer2 = Class.forName("java.text.Normalizer");
                Class<?> Form2 = Class.forName("java.text.Normalizer$Form");
                normalize = Normalizer2.getMethod("normalize", CharSequence.class, Form2);
                NFD = Form2.getField("NFD").get(null);
            }
            catch (Exception e) {
                NFD = null;
                normalize = null;
            }
        }
    }
}

