/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.UUID;

@BridgeMethodsAdded
public class UUIDUtil {
    public byte[] toByteArray(UUID uuid) {
        return this.longToByteArray(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public UUID fromByteArray(byte[] uuidBytes) {
        if (uuidBytes.length != 16) {
            throw new IllegalArgumentException("UUID Bytes must be exactly 16 bytes long, it was " + uuidBytes.length);
        }
        long[] bytes = this.byteArrayToLongArray(uuidBytes);
        return new UUID(bytes[0], bytes[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] longToByteArray(long ... values) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                DataOutputStream dos = new DataOutputStream(baos);
                for (long value : values) {
                    dos.writeLong(value);
                }
                dos.flush();
            }
            finally {
                baos.close();
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] byteArrayToLongArray(byte[] values) {
        long[] lArray;
        if (values.length % 8 != 0) {
            throw new IllegalArgumentException("byte[] is not a multiple of 8 bytes");
        }
        long[] result = new long[values.length / 8];
        ByteArrayInputStream bais = new ByteArrayInputStream(values);
        try {
            DataInputStream dos = new DataInputStream(bais);
            for (int i = 0; i < result.length; ++i) {
                result[i] = dos.readLong();
            }
            lArray = result;
        }
        catch (Throwable throwable) {
            try {
                bais.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        bais.close();
        return lArray;
    }
}

