/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ud.client;

import com.urbancode.ud.client.UDRestClient;
import java.io.IOException;
import java.net.URI;
import java.util.UUID;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.impl.client.DefaultHttpClient;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class PropertyClient
extends UDRestClient {
    public PropertyClient(URI url, String clientUser, String clientPassword) {
        super(url, clientUser, clientPassword);
    }

    public PropertyClient(URI url, String clientUser, String clientPassword, boolean trustAllCerts) {
        super(url, clientUser, clientPassword, trustAllCerts);
    }

    public PropertyClient(URI url, DefaultHttpClient client) {
        super(url, client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID createPropDef(UUID propSheetDefId, String propSheetDefPath, String name, String description, String label, Boolean required, String type, String value) throws IOException, JSONException {
        UUID result;
        String uri = this.url + "/property/propSheetDef/" + this.encodePath(propSheetDefPath) + ".-1/propDefs";
        JSONObject propDefObject = new JSONObject();
        propDefObject.put("name", name);
        propDefObject.put("description", description);
        propDefObject.put("label", label);
        propDefObject.put("required", required.toString());
        propDefObject.put("type", type);
        propDefObject.put("value", value);
        propDefObject.put("definitionGroupId", propSheetDefId);
        HttpPut method = new HttpPut(uri);
        method.setEntity(this.getStringEntity(propDefObject));
        CloseableHttpResponse response = this.invokeMethod(method);
        try {
            String body = this.getBody(response);
            result = UUID.fromString(new JSONObject(body).getString("id"));
        }
        finally {
            response.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray getPropSheetDefPropDefs(String propSheetDefPath) throws IOException, JSONException {
        JSONArray result = null;
        String uri = this.url + "/property/propSheetDef/" + this.encodePath(propSheetDefPath) + ".-1/propDefs";
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod(method);
        try {
            String body = this.getBody(response);
            result = new JSONArray(body);
        }
        finally {
            response.close();
        }
        return result;
    }

    public JSONArray getUnversionedPropSheetDefPropDefs(String propSheetDefId) throws IOException, JSONException {
        JSONArray result = null;
        String uri = this.url + "/property/propSheetDef/" + this.encodePath(propSheetDefId) + "/propDefs";
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        result = new JSONArray(body);
        return result;
    }

    public JSONArray updatePropDefs(String propSheetDefPath, JSONArray propDefs, boolean deleteExtraProps) throws IOException, JSONException {
        JSONArray result = null;
        String uri = this.url + "/property/propSheetDef/" + this.encodePath(propSheetDefPath) + ".-1/propDefs/update/" + String.valueOf(deleteExtraProps);
        HttpPut method = new HttpPut(uri);
        method.setEntity(this.getStringEntity(propDefs));
        CloseableHttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        result = new JSONArray(body);
        return result;
    }

    public JSONArray updateUnversionedPropDefs(String propSheetDefID, JSONArray propDefs, boolean deleteExtraProps) throws IOException, JSONException {
        JSONArray result = null;
        String uri = this.url + "/property/propSheetDef/" + this.encodePath(propSheetDefID) + "/propDefs/update/" + String.valueOf(deleteExtraProps);
        HttpPut method = new HttpPut(uri);
        method.setEntity(this.getStringEntity(propDefs));
        CloseableHttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        result = new JSONArray(body);
        return result;
    }

    public JSONObject updateResourcePropValues(String propSheetPath, String propSheetVer, JSONObject propDefs) throws IOException, JSONException {
        JSONObject result = null;
        String uri = this.url + "/property/propSheet/" + this.encodePath(propSheetPath) + "." + propSheetVer + "/allPropValuesFromBatch/";
        HttpPut method = new HttpPut(uri);
        method.addHeader("Version", propSheetVer);
        method.setEntity(this.getStringEntity(propDefs));
        CloseableHttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        if (body.length() > 0) {
            result = new JSONObject(body);
        }
        return result;
    }
}

