/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.dbprofiler;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.clock.Clock;
import com.urbancode.commons.util.dbprofiler.DbProfile;
import com.urbancode.commons.util.dbprofiler.DbProfileCounter;

@BridgeMethodsAdded
class RealDbProfileCounter
extends DbProfileCounter {
    private final Clock clock;
    private long executeCount;
    private long commitCount;
    private long rollbackCount;
    private long executeTime;
    private long commitTime;
    private long rollbackTime;
    private long startExecute;
    private long startCommit;
    private long startRollback;

    RealDbProfileCounter(Clock clock) {
        this.clock = Check.nonNull(clock, "clock");
    }

    public void startCommit() {
        ++this.commitCount;
        this.startCommit = this.clock.now();
    }

    public void endCommit() {
        this.commitTime += this.clock.now() - this.startCommit;
    }

    public void startExecute() {
        ++this.executeCount;
        this.startExecute = this.clock.now();
    }

    public void endExecute() {
        this.executeTime += this.clock.now() - this.startExecute;
    }

    public void startRollback() {
        ++this.rollbackCount;
        this.startRollback = this.clock.now();
    }

    public void endRollback() {
        this.rollbackTime += this.clock.now() - this.startRollback;
    }

    public DbProfile getProfile() {
        return new DbProfile(this.executeCount, this.commitCount, this.rollbackCount, this.executeTime, this.commitTime, this.rollbackTime);
    }
}

