/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.redaction;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.redaction.DescendingLengthComparator;
import java.util.Arrays;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
class Redactor {
    public static final String REPLACEMENT = "****";

    Redactor() {
    }

    public String redact(Set<String> secureValues, String src) {
        String[] sortedSecureValues = secureValues.toArray(new String[0]);
        Arrays.sort(sortedSecureValues, new DescendingLengthComparator());
        return this.redact(sortedSecureValues, src);
    }

    protected String redact(String[] sortedSecureValues, String src) {
        String redacted = src;
        if (redacted != null && sortedSecureValues != null) {
            for (String secure : sortedSecureValues) {
                if (secure == null || secure.length() <= 0) continue;
                redacted = this.replaceIgnoreEol(redacted, secure, REPLACEMENT);
            }
        }
        return redacted;
    }

    protected String normalize(String str) {
        return str.replaceAll("\r\n|\r|\n", "\n");
    }

    protected int safePrefixLength(String[] sortedSecureValues, StringBuilder buffer) {
        int safePrefixLen = buffer.length();
        for (String redact : sortedSecureValues) {
            safePrefixLen = Math.min(safePrefixLen, this.safePrefixLen0(buffer, redact));
        }
        return safePrefixLen;
    }

    private int safePrefixLen0(StringBuilder buffer, String redact) {
        int safe = buffer.length();
        for (int i = buffer.length() - 1; i >= 0; --i) {
            String tail = this.normalize(buffer.substring(i));
            if (tail.length() >= redact.length()) {
                if (!tail.equals(redact)) break;
                safe = buffer.length();
                break;
            }
            if (!redact.startsWith(tail)) continue;
            safe = i;
        }
        return safe;
    }

    private String replaceIgnoreEol(String source, String toReplace, String replacment) {
        if (toReplace.length() > source.length()) {
            return source;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < source.length(); ++i) {
            boolean match = false;
            int matchStart = i;
            int matchEnd = i;
            int j = i;
            int k = 0;
            while (j < source.length()) {
                boolean charMatch;
                char sourceChar = source.charAt(j);
                char toReplChar = toReplace.charAt(k);
                boolean bl = charMatch = toReplChar == sourceChar;
                if (toReplChar == '\n' && sourceChar == '\r') {
                    charMatch = true;
                    if (sourceChar == '\r' && j + 1 < source.length() && source.charAt(j + 1) == '\n') {
                        ++j;
                    }
                }
                if (!charMatch) break;
                if (k == toReplace.length() - 1) {
                    match = true;
                    matchEnd = j;
                    break;
                }
                ++j;
                ++k;
            }
            if (!match) {
                result.append(source.subSequence(matchStart, matchEnd + 1));
            } else {
                result.append(replacment);
            }
            i = matchEnd;
        }
        return result.toString();
    }
}

